/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.first;

import org.apache.druid.collections.SerializablePair;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.segment.BaseLongColumnValueSelector;

public class LongFirstAggregator
implements Aggregator {
    private final BaseLongColumnValueSelector valueSelector;
    private final BaseLongColumnValueSelector timeSelector;
    protected long firstTime;
    protected long firstValue;

    public LongFirstAggregator(BaseLongColumnValueSelector timeSelector, BaseLongColumnValueSelector valueSelector) {
        this.valueSelector = valueSelector;
        this.timeSelector = timeSelector;
        this.firstTime = Long.MAX_VALUE;
        this.firstValue = 0L;
    }

    @Override
    public void aggregate() {
        long time = this.timeSelector.getLong();
        if (time < this.firstTime) {
            this.firstTime = time;
            this.firstValue = this.valueSelector.getLong();
        }
    }

    @Override
    public Object get() {
        return new SerializablePair((Object)this.firstTime, (Object)this.firstValue);
    }

    @Override
    public float getFloat() {
        return this.firstValue;
    }

    @Override
    public double getDouble() {
        return this.firstValue;
    }

    @Override
    public long getLong() {
        return this.firstValue;
    }

    @Override
    public void close() {
    }
}

