/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.post;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;

public class FieldAccessPostAggregator
implements PostAggregator {
    private final String name;
    private final String fieldName;

    @JsonCreator
    public FieldAccessPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName) {
        Preconditions.checkNotNull((Object)fieldName);
        this.name = name;
        this.fieldName = fieldName;
    }

    @Override
    public Set<String> getDependentFields() {
        return Sets.newHashSet((Object[])new String[]{this.fieldName});
    }

    @Override
    public Comparator getComparator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object compute(Map<String, Object> combinedAggregators) {
        return combinedAggregators.get(this.fieldName);
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public FieldAccessPostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return this;
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(5).appendString(this.fieldName).build();
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    public String toString() {
        return "FieldAccessPostAggregator{name='" + this.name + '\'' + ", fieldName='" + this.fieldName + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldAccessPostAggregator that = (FieldAccessPostAggregator)o;
        if (!this.fieldName.equals(that.fieldName)) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.fieldName.hashCode();
        return result;
    }
}

