/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.List;
import javax.annotation.Nonnull;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.expression.ExprUtils;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

public class TimestampExtractExprMacro
implements ExprMacroTable.ExprMacro {
    public String name() {
        return "timestamp_extract";
    }

    public Expr apply(List<Expr> args) {
        if (args.size() < 2 || args.size() > 3) {
            throw new IAE("Function[%s] must have 2 to 3 arguments", new Object[]{this.name()});
        }
        if (!args.get(1).isLiteral() || args.get(1).getLiteralValue() == null) {
            throw new IAE("Function[%s] unit arg must be literal", new Object[]{this.name()});
        }
        if (args.size() > 2 && !args.get(2).isLiteral()) {
            throw new IAE("Function[%s] timezone arg must be literal", new Object[]{this.name()});
        }
        final Expr arg = args.get(0);
        final Unit unit = Unit.valueOf(StringUtils.toUpperCase((String)((String)args.get(1).getLiteralValue())));
        DateTimeZone timeZone = args.size() > 2 ? ExprUtils.toTimeZone(args.get(2)) : DateTimeZone.UTC;
        final ISOChronology chronology = ISOChronology.getInstance((DateTimeZone)timeZone);
        class TimestampExtractExpr
        implements Expr {
            TimestampExtractExpr() {
            }

            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                Object val = arg.eval(bindings).value();
                if (val == null) {
                    return ExprEval.of(null);
                }
                DateTime dateTime = new DateTime(val, (Chronology)chronology);
                switch (unit) {
                    case EPOCH: {
                        return ExprEval.of((long)(dateTime.getMillis() / 1000L));
                    }
                    case SECOND: {
                        return ExprEval.of((long)dateTime.secondOfMinute().get());
                    }
                    case MINUTE: {
                        return ExprEval.of((long)dateTime.minuteOfHour().get());
                    }
                    case HOUR: {
                        return ExprEval.of((long)dateTime.hourOfDay().get());
                    }
                    case DAY: {
                        return ExprEval.of((long)dateTime.dayOfMonth().get());
                    }
                    case DOW: {
                        return ExprEval.of((long)dateTime.dayOfWeek().get());
                    }
                    case DOY: {
                        return ExprEval.of((long)dateTime.dayOfYear().get());
                    }
                    case WEEK: {
                        return ExprEval.of((long)dateTime.weekOfWeekyear().get());
                    }
                    case MONTH: {
                        return ExprEval.of((long)dateTime.monthOfYear().get());
                    }
                    case QUARTER: {
                        return ExprEval.of((long)((dateTime.monthOfYear().get() - 1) / 3 + 1));
                    }
                    case YEAR: {
                        return ExprEval.of((long)dateTime.year().get());
                    }
                }
                throw new ISE("Unhandled unit[%s]", new Object[]{unit});
            }

            public void visit(Expr.Visitor visitor) {
                arg.visit(visitor);
                visitor.visit((Expr)this);
            }
        }
        return new TimestampExtractExpr();
    }

    public static enum Unit {
        EPOCH,
        SECOND,
        MINUTE,
        HOUR,
        DAY,
        DOW,
        DOY,
        WEEK,
        MONTH,
        QUARTER,
        YEAR;

    }
}

