/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.having;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import org.apache.druid.data.input.Row;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.groupby.having.BaseHavingSpec;
import org.apache.druid.query.groupby.having.HavingSpecMetricComparator;

public class EqualToHavingSpec
extends BaseHavingSpec {
    private final String aggregationName;
    private final Number value;
    private volatile Map<String, AggregatorFactory> aggregators;

    @JsonCreator
    public EqualToHavingSpec(@JsonProperty(value="aggregation") String aggName, @JsonProperty(value="value") Number value) {
        this.aggregationName = aggName;
        this.value = value;
    }

    @JsonProperty(value="value")
    public Number getValue() {
        return this.value;
    }

    @JsonProperty(value="aggregation")
    public String getAggregationName() {
        return this.aggregationName;
    }

    @Override
    public void setAggregators(Map<String, AggregatorFactory> aggregators) {
        this.aggregators = aggregators;
    }

    @Override
    public boolean eval(Row row) {
        Object metricVal = row.getRaw(this.aggregationName);
        if (metricVal == null || this.value == null) {
            return metricVal == null && this.value == null;
        }
        return HavingSpecMetricComparator.compare(this.aggregationName, this.value, this.aggregators, metricVal) == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EqualToHavingSpec that = (EqualToHavingSpec)o;
        if (this.aggregationName != null ? !this.aggregationName.equals(that.aggregationName) : that.aggregationName != null) {
            return false;
        }
        if (this.value != null && that.value != null) {
            return Double.compare(this.value.doubleValue(), that.value.doubleValue()) == 0;
        }
        return this.value == null && that.value == null;
    }

    public int hashCode() {
        int result = this.aggregationName != null ? this.aggregationName.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EqualToHavingSpec");
        sb.append("{aggregationName='").append(this.aggregationName).append('\'');
        sb.append(", value=").append(this.value);
        sb.append('}');
        return sb.toString();
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(4).appendString(this.aggregationName).appendByteArray(StringUtils.toUtf8((String)String.valueOf(this.value))).build();
    }
}

