/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.scan.ScanQueryConfig;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;

public class ScanQuery
extends BaseQuery<ScanResultValue> {
    public static final String RESULT_FORMAT_LIST = "list";
    public static final String RESULT_FORMAT_COMPACTED_LIST = "compactedList";
    public static final String RESULT_FORMAT_VALUE_VECTOR = "valueVector";
    private final VirtualColumns virtualColumns;
    private final String resultFormat;
    private final int batchSize;
    private final long limit;
    private final DimFilter dimFilter;
    private final List<String> columns;
    private final Boolean legacy;

    @JsonCreator
    public ScanQuery(@JsonProperty(value="dataSource") DataSource dataSource, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="virtualColumns") VirtualColumns virtualColumns, @JsonProperty(value="resultFormat") String resultFormat, @JsonProperty(value="batchSize") int batchSize, @JsonProperty(value="limit") long limit, @JsonProperty(value="filter") DimFilter dimFilter, @JsonProperty(value="columns") List<String> columns, @JsonProperty(value="legacy") Boolean legacy, @JsonProperty(value="context") Map<String, Object> context) {
        super(dataSource, querySegmentSpec, false, context);
        this.virtualColumns = VirtualColumns.nullToEmpty(virtualColumns);
        this.resultFormat = resultFormat == null ? RESULT_FORMAT_LIST : resultFormat;
        this.batchSize = batchSize == 0 ? 20480 : batchSize;
        this.limit = limit == 0L ? Long.MAX_VALUE : limit;
        Preconditions.checkArgument((this.batchSize > 0 ? 1 : 0) != 0, (Object)"batchSize must be greater than 0");
        Preconditions.checkArgument((this.limit > 0L ? 1 : 0) != 0, (Object)"limit must be greater than 0");
        this.dimFilter = dimFilter;
        this.columns = columns;
        this.legacy = legacy;
    }

    @JsonProperty
    public VirtualColumns getVirtualColumns() {
        return this.virtualColumns;
    }

    @JsonProperty
    public String getResultFormat() {
        return this.resultFormat;
    }

    @JsonProperty
    public int getBatchSize() {
        return this.batchSize;
    }

    @JsonProperty
    public long getLimit() {
        return this.limit;
    }

    @Override
    public boolean hasFilters() {
        return this.dimFilter != null;
    }

    @Override
    @JsonProperty
    public DimFilter getFilter() {
        return this.dimFilter;
    }

    @Override
    public String getType() {
        return "scan";
    }

    @JsonProperty
    public List<String> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public Boolean isLegacy() {
        return this.legacy;
    }

    public ScanQuery withNonNullLegacy(ScanQueryConfig scanQueryConfig) {
        return ScanQueryBuilder.copy(this).legacy(this.legacy != null ? this.legacy.booleanValue() : scanQueryConfig.isLegacy()).build();
    }

    @Override
    public Query<ScanResultValue> withQuerySegmentSpec(QuerySegmentSpec querySegmentSpec) {
        return ScanQueryBuilder.copy(this).intervals(querySegmentSpec).build();
    }

    @Override
    public Query<ScanResultValue> withDataSource(DataSource dataSource) {
        return ScanQueryBuilder.copy(this).dataSource(dataSource).build();
    }

    @Override
    public Query<ScanResultValue> withOverriddenContext(Map<String, Object> contextOverrides) {
        return ScanQueryBuilder.copy(this).context(ScanQuery.computeOverriddenContext(this.getContext(), contextOverrides)).build();
    }

    public ScanQuery withDimFilter(DimFilter dimFilter) {
        return ScanQueryBuilder.copy(this).filters(dimFilter).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScanQuery scanQuery = (ScanQuery)o;
        return this.batchSize == scanQuery.batchSize && this.limit == scanQuery.limit && this.legacy == scanQuery.legacy && Objects.equals(this.virtualColumns, scanQuery.virtualColumns) && Objects.equals(this.resultFormat, scanQuery.resultFormat) && Objects.equals(this.dimFilter, scanQuery.dimFilter) && Objects.equals(this.columns, scanQuery.columns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.virtualColumns, this.resultFormat, this.batchSize, this.limit, this.dimFilter, this.columns, this.legacy);
    }

    public String toString() {
        return "ScanQuery{dataSource='" + this.getDataSource() + '\'' + ", querySegmentSpec=" + this.getQuerySegmentSpec() + ", virtualColumns=" + this.getVirtualColumns() + ", resultFormat='" + this.resultFormat + '\'' + ", batchSize=" + this.batchSize + ", limit=" + this.limit + ", dimFilter=" + this.dimFilter + ", columns=" + this.columns + ", legacy=" + this.legacy + '}';
    }

    public static ScanQueryBuilder newScanQueryBuilder() {
        return new ScanQueryBuilder();
    }

    public static class ScanQueryBuilder {
        private DataSource dataSource = null;
        private QuerySegmentSpec querySegmentSpec = null;
        private VirtualColumns virtualColumns = null;
        private Map<String, Object> context = null;
        private String resultFormat = null;
        private int batchSize = 0;
        private long limit = 0L;
        private DimFilter dimFilter = null;
        private List<String> columns = new ArrayList<String>();
        private Boolean legacy = null;

        public ScanQuery build() {
            return new ScanQuery(this.dataSource, this.querySegmentSpec, this.virtualColumns, this.resultFormat, this.batchSize, this.limit, this.dimFilter, this.columns, this.legacy, this.context);
        }

        public static ScanQueryBuilder copy(ScanQuery query) {
            return new ScanQueryBuilder().dataSource(query.getDataSource()).intervals(query.getQuerySegmentSpec()).virtualColumns(query.getVirtualColumns()).resultFormat(query.getResultFormat()).batchSize(query.getBatchSize()).limit(query.getLimit()).filters(query.getFilter()).columns(query.getColumns()).legacy(query.isLegacy()).context(query.getContext());
        }

        public ScanQueryBuilder dataSource(String ds) {
            this.dataSource = new TableDataSource(ds);
            return this;
        }

        public ScanQueryBuilder dataSource(DataSource ds) {
            this.dataSource = ds;
            return this;
        }

        public ScanQueryBuilder intervals(QuerySegmentSpec q) {
            this.querySegmentSpec = q;
            return this;
        }

        public ScanQueryBuilder virtualColumns(VirtualColumns virtualColumns) {
            this.virtualColumns = virtualColumns;
            return this;
        }

        public ScanQueryBuilder virtualColumns(VirtualColumn ... virtualColumns) {
            return this.virtualColumns(VirtualColumns.create(Arrays.asList(virtualColumns)));
        }

        public ScanQueryBuilder context(Map<String, Object> c) {
            this.context = c;
            return this;
        }

        public ScanQueryBuilder resultFormat(String r) {
            this.resultFormat = r;
            return this;
        }

        public ScanQueryBuilder batchSize(int b) {
            this.batchSize = b;
            return this;
        }

        public ScanQueryBuilder limit(long l) {
            this.limit = l;
            return this;
        }

        public ScanQueryBuilder filters(DimFilter f) {
            this.dimFilter = f;
            return this;
        }

        public ScanQueryBuilder columns(List<String> c) {
            this.columns = c;
            return this;
        }

        public ScanQueryBuilder columns(String ... c) {
            this.columns = Arrays.asList(c);
            return this;
        }

        public ScanQueryBuilder legacy(Boolean legacy) {
            this.legacy = legacy;
            return this;
        }
    }
}

