/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.timeseries;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.query.timeseries.DefaultTimeseriesQueryMetrics;
import org.apache.druid.query.timeseries.TimeseriesQueryMetrics;
import org.apache.druid.query.timeseries.TimeseriesQueryMetricsFactory;

@LazySingleton
public class DefaultTimeseriesQueryMetricsFactory
implements TimeseriesQueryMetricsFactory {
    private static final TimeseriesQueryMetricsFactory INSTANCE = new DefaultTimeseriesQueryMetricsFactory(new DefaultObjectMapper());
    private final ObjectMapper jsonMapper;

    @VisibleForTesting
    public static TimeseriesQueryMetricsFactory instance() {
        return INSTANCE;
    }

    @Inject
    public DefaultTimeseriesQueryMetricsFactory(@Json ObjectMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    @Override
    public TimeseriesQueryMetrics makeMetrics() {
        return new DefaultTimeseriesQueryMetrics(this.jsonMapper);
    }
}

