/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.timeseries;

import com.google.common.base.Function;
import java.util.List;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.QueryRunnerHelper;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesResultBuilder;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.SegmentMissingException;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.filter.Filters;

public class TimeseriesQueryEngine {
    public Sequence<Result<TimeseriesResultValue>> process(TimeseriesQuery query, StorageAdapter adapter) {
        if (adapter == null) {
            throw new SegmentMissingException("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
        }
        Filter filter = Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getDimensionsFilter()));
        int limit = query.getLimit();
        Sequence<Result<TimeseriesResultValue>> result = this.generateTimeseriesResult(adapter, query, filter);
        if (limit < Integer.MAX_VALUE) {
            return result.limit(limit);
        }
        return result;
    }

    private Sequence<Result<TimeseriesResultValue>> generateTimeseriesResult(StorageAdapter adapter, final TimeseriesQuery query, Filter filter) {
        return QueryRunnerHelper.makeCursorBasedQuery(adapter, query.getQuerySegmentSpec().getIntervals(), filter, query.getVirtualColumns(), query.isDescending(), query.getGranularity(), new Function<Cursor, Result<TimeseriesResultValue>>(){
            private final boolean skipEmptyBuckets;
            private final List<AggregatorFactory> aggregatorSpecs;
            {
                this.skipEmptyBuckets = query.isSkipEmptyBuckets();
                this.aggregatorSpecs = query.getAggregatorSpecs();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Result<TimeseriesResultValue> apply(Cursor cursor) {
                if (this.skipEmptyBuckets && cursor.isDone()) {
                    return null;
                }
                Aggregator[] aggregators = new Aggregator[this.aggregatorSpecs.size()];
                String[] aggregatorNames = new String[this.aggregatorSpecs.size()];
                for (int i = 0; i < this.aggregatorSpecs.size(); ++i) {
                    aggregators[i] = this.aggregatorSpecs.get(i).factorize(cursor.getColumnSelectorFactory());
                    aggregatorNames[i] = this.aggregatorSpecs.get(i).getName();
                }
                try {
                    Result<TimeseriesResultValue> retVal;
                    while (!cursor.isDone()) {
                        for (Aggregator aggregator : aggregators) {
                            aggregator.aggregate();
                        }
                        cursor.advance();
                    }
                    TimeseriesResultBuilder bob = new TimeseriesResultBuilder(cursor.getTime());
                    for (int i = 0; i < this.aggregatorSpecs.size(); ++i) {
                        bob.addMetric(aggregatorNames[i], aggregators[i]);
                    }
                    Result<TimeseriesResultValue> result = retVal = bob.build();
                    return result;
                }
                finally {
                    for (Aggregator agg : aggregators) {
                        agg.close();
                    }
                }
            }
        });
    }
}

