/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.primitives.Ints;
import com.google.inject.Inject;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ConciseBitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.spatial.ImmutableRTree;
import org.apache.druid.common.utils.SerializerUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.smoosh.Smoosh;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.segment.IndexableAdapter;
import org.apache.druid.segment.MMappedIndex;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.MetricHolder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexIndexableAdapter;
import org.apache.druid.segment.RowPointer;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.segment.SegmentValidationException;
import org.apache.druid.segment.SimpleQueryableIndex;
import org.apache.druid.segment.TransformableRowIterator;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnDescriptor;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.BitmapSerde;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.ColumnarMultiInts;
import org.apache.druid.segment.data.CompressedColumnarLongsSupplier;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.ImmutableRTreeObjectStrategy;
import org.apache.druid.segment.data.IndexedIterable;
import org.apache.druid.segment.data.VSizeColumnarMultiInts;
import org.apache.druid.segment.serde.BitmapIndexColumnPartSupplier;
import org.apache.druid.segment.serde.ComplexColumnPartSupplier;
import org.apache.druid.segment.serde.DictionaryEncodedColumnSupplier;
import org.apache.druid.segment.serde.FloatNumericColumnSupplier;
import org.apache.druid.segment.serde.LongNumericColumnSupplier;
import org.apache.druid.segment.serde.SpatialIndexColumnPartSupplier;
import org.joda.time.Interval;

public class IndexIO {
    public static final byte V8_VERSION = 8;
    public static final byte V9_VERSION = 9;
    public static final int CURRENT_VERSION_ID = 9;
    public static BitmapSerdeFactory LEGACY_FACTORY = new BitmapSerde.LegacyBitmapSerdeFactory();
    public static final ByteOrder BYTE_ORDER = ByteOrder.nativeOrder();
    private final Map<Integer, IndexLoader> indexLoaders;
    private static final EmittingLogger log = new EmittingLogger(IndexIO.class);
    private static final SerializerUtils serializerUtils = new SerializerUtils();
    private final ObjectMapper mapper;

    @Inject
    public IndexIO(ObjectMapper mapper, ColumnConfig columnConfig) {
        this.mapper = (ObjectMapper)Preconditions.checkNotNull((Object)mapper, (Object)"null ObjectMapper");
        Preconditions.checkNotNull((Object)columnConfig, (Object)"null ColumnConfig");
        ImmutableMap.Builder indexLoadersBuilder = ImmutableMap.builder();
        LegacyIndexLoader legacyIndexLoader = new LegacyIndexLoader(new DefaultIndexIOHandler(), columnConfig);
        for (int i = 0; i <= 8; ++i) {
            indexLoadersBuilder.put((Object)i, (Object)legacyIndexLoader);
        }
        indexLoadersBuilder.put((Object)9, (Object)new V9IndexLoader(columnConfig));
        this.indexLoaders = indexLoadersBuilder.build();
    }

    public void validateTwoSegments(File dir1, File dir2) throws IOException {
        try (QueryableIndex queryableIndex1 = this.loadIndex(dir1);
             QueryableIndex queryableIndex2 = this.loadIndex(dir2);){
            this.validateTwoSegments(new QueryableIndexIndexableAdapter(queryableIndex1), new QueryableIndexIndexableAdapter(queryableIndex2));
        }
    }

    public void validateTwoSegments(IndexableAdapter adapter1, IndexableAdapter adapter2) {
        HashSet metNames2;
        HashSet dimNames2;
        if (adapter1.getNumRows() != adapter2.getNumRows()) {
            throw new SegmentValidationException("Row count mismatch. Expected [%d] found [%d]", adapter1.getNumRows(), adapter2.getNumRows());
        }
        HashSet dimNames1 = Sets.newHashSet(adapter1.getDimensionNames());
        if (!dimNames1.equals(dimNames2 = Sets.newHashSet(adapter2.getDimensionNames()))) {
            throw new SegmentValidationException("Dimension names differ. Expected [%s] found [%s]", dimNames1, dimNames2);
        }
        HashSet metNames1 = Sets.newHashSet(adapter1.getMetricNames());
        if (!metNames1.equals(metNames2 = Sets.newHashSet(adapter2.getMetricNames()))) {
            throw new SegmentValidationException("Metric names differ. Expected [%s] found [%s]", metNames1, metNames2);
        }
        TransformableRowIterator it1 = adapter1.getRows();
        TransformableRowIterator it2 = adapter2.getRows();
        long row = 0L;
        while (it1.moveToNext()) {
            if (!it2.moveToNext()) {
                throw new SegmentValidationException("Unexpected end of second adapter", new Object[0]);
            }
            RowPointer rp1 = it1.getPointer();
            RowPointer rp2 = it2.getPointer();
            ++row;
            if (rp1.getRowNum() != rp2.getRowNum()) {
                throw new SegmentValidationException("Row number mismatch: [%d] vs [%d]", rp1.getRowNum(), rp2.getRowNum());
            }
            try {
                IndexIO.validateRowValues(rp1, adapter1, rp2, adapter2);
            }
            catch (SegmentValidationException ex) {
                throw new SegmentValidationException(ex, "Validation failure on row %d: [%s] vs [%s]", row, rp1, rp2);
            }
        }
        if (it2.moveToNext()) {
            throw new SegmentValidationException("Unexpected end of first adapter", new Object[0]);
        }
        if (row != (long)adapter1.getNumRows()) {
            throw new SegmentValidationException("Actual Row count mismatch. Expected [%d] found [%d]", row, adapter1.getNumRows());
        }
    }

    public QueryableIndex loadIndex(File inDir) throws IOException {
        int version = SegmentUtils.getVersionFromDir((File)inDir);
        IndexLoader loader = this.indexLoaders.get(version);
        if (loader != null) {
            return loader.load(inDir, this.mapper);
        }
        throw new ISE("Unknown index version[%s]", new Object[]{version});
    }

    public static void checkFileSize(File indexFile) throws IOException {
        long fileSize = indexFile.length();
        if (fileSize > Integer.MAX_VALUE) {
            throw new IOE("File[%s] too large[%d]", new Object[]{indexFile, fileSize});
        }
    }

    private static void validateRowValues(RowPointer rp1, IndexableAdapter adapter1, RowPointer rp2, IndexableAdapter adapter2) {
        if (rp1.getTimestamp() != rp2.getTimestamp()) {
            throw new SegmentValidationException("Timestamp mismatch. Expected %d found %d", rp1.getTimestamp(), rp2.getTimestamp());
        }
        List<Object> dims1 = rp1.getDimensionValuesForDebug();
        List<Object> dims2 = rp2.getDimensionValuesForDebug();
        if (dims1.size() != dims2.size()) {
            throw new SegmentValidationException("Dim lengths not equal %s vs %s", dims1, dims2);
        }
        List<String> dim1Names = adapter1.getDimensionNames();
        List<String> dim2Names = adapter2.getDimensionNames();
        int dimCount = dims1.size();
        for (int i = 0; i < dimCount; ++i) {
            ValueType dim2Type;
            String dim1Name = dim1Names.get(i);
            String dim2Name = dim2Names.get(i);
            ColumnCapabilities capabilities1 = adapter1.getCapabilities(dim1Name);
            ColumnCapabilities capabilities2 = adapter2.getCapabilities(dim2Name);
            ValueType dim1Type = capabilities1.getType();
            if (dim1Type != (dim2Type = capabilities2.getType())) {
                throw new SegmentValidationException("Dim [%s] types not equal. Expected %d found %d", new Object[]{dim1Name, dim1Type, dim2Type});
            }
            Object vals1 = dims1.get(i);
            Object vals2 = dims2.get(i);
            if (IndexIO.isNullRow(vals1) ^ IndexIO.isNullRow(vals2)) {
                throw IndexIO.notEqualValidationException(dim1Name, vals1, vals2);
            }
            boolean vals1IsList = vals1 instanceof List;
            boolean vals2IsList = vals2 instanceof List;
            if (!(vals1IsList ^ vals2IsList ? (vals1IsList ? ((List)vals1).size() != 1 || !Objects.equals(((List)vals1).get(0), vals2) : ((List)vals2).size() != 1 || !Objects.equals(((List)vals2).get(0), vals1)) : !Objects.equals(vals1, vals2))) continue;
            throw IndexIO.notEqualValidationException(dim1Name, vals1, vals2);
        }
    }

    private static boolean isNullRow(@Nullable Object row) {
        if (row == null) {
            return true;
        }
        if (!(row instanceof List)) {
            return false;
        }
        List rowAsList = (List)row;
        int rowSize = rowAsList.size();
        for (int i = 0; i < rowSize; ++i) {
            Object v = rowAsList.get(i);
            if (v == null) continue;
            return false;
        }
        return true;
    }

    private static SegmentValidationException notEqualValidationException(String dimName, Object v1, Object v2) {
        return new SegmentValidationException("Dim [%s] values not equal. Expected %s found %s", dimName, v1, v2);
    }

    public static File makeDimFile(File dir, String dimension) {
        return new File(dir, StringUtils.format((String)"dim_%s.drd", (Object[])new Object[]{dimension}));
    }

    public static File makeTimeFile(File dir, ByteOrder order) {
        return new File(dir, StringUtils.format((String)"time_%s.drd", (Object[])new Object[]{order}));
    }

    public static File makeMetricFile(File dir, String metricName, ByteOrder order) {
        return new File(dir, StringUtils.format((String)"met_%s_%s.drd", (Object[])new Object[]{metricName, order}));
    }

    static class V9IndexLoader
    implements IndexLoader {
        private final ColumnConfig columnConfig;

        V9IndexLoader(ColumnConfig columnConfig) {
            this.columnConfig = columnConfig;
        }

        @Override
        public QueryableIndex load(File inDir, ObjectMapper mapper) throws IOException {
            log.debug("Mapping v9 index[%s]", new Object[]{inDir});
            long startTime = System.currentTimeMillis();
            int theVersion = Ints.fromByteArray((byte[])Files.toByteArray((File)new File(inDir, "version.bin")));
            if (theVersion != 9) {
                throw new IAE("Expected version[9], got[%d]", new Object[]{theVersion});
            }
            SmooshedFileMapper smooshedFiles = Smoosh.map((File)inDir);
            ByteBuffer indexBuffer = smooshedFiles.mapFile("index.drd");
            GenericIndexed<String> cols = GenericIndexed.read(indexBuffer, GenericIndexed.STRING_STRATEGY, smooshedFiles);
            GenericIndexed<String> dims = GenericIndexed.read(indexBuffer, GenericIndexed.STRING_STRATEGY, smooshedFiles);
            Interval dataInterval = Intervals.utc((long)indexBuffer.getLong(), (long)indexBuffer.getLong());
            BitmapSerdeFactory segmentBitmapSerdeFactory = indexBuffer.hasRemaining() ? (BitmapSerdeFactory)mapper.readValue(serializerUtils.readString(indexBuffer), BitmapSerdeFactory.class) : new BitmapSerde.LegacyBitmapSerdeFactory();
            Metadata metadata = null;
            ByteBuffer metadataBB = smooshedFiles.mapFile("metadata.drd");
            if (metadataBB != null) {
                try {
                    metadata = (Metadata)mapper.readValue(serializerUtils.readBytes(metadataBB, metadataBB.remaining()), Metadata.class);
                }
                catch (JsonParseException | JsonMappingException ex) {
                    log.warn(ex, "Failed to load metadata for segment [%s]", new Object[]{inDir});
                }
                catch (IOException ex) {
                    throw new IOException("Failed to read metadata", ex);
                }
            }
            HashMap<String, ColumnHolder> columns = new HashMap<String, ColumnHolder>();
            for (String columnName : cols) {
                if (Strings.isNullOrEmpty((String)columnName)) {
                    log.warn("Null or Empty Dimension found in the file : " + inDir, new Object[0]);
                    continue;
                }
                columns.put(columnName, this.deserializeColumn(mapper, smooshedFiles.mapFile(columnName), smooshedFiles));
            }
            columns.put("__time", this.deserializeColumn(mapper, smooshedFiles.mapFile("__time"), smooshedFiles));
            SimpleQueryableIndex index = new SimpleQueryableIndex(dataInterval, dims, segmentBitmapSerdeFactory.getBitmapFactory(), columns, smooshedFiles, metadata);
            log.debug("Mapped v9 index[%s] in %,d millis", new Object[]{inDir, System.currentTimeMillis() - startTime});
            return index;
        }

        private ColumnHolder deserializeColumn(ObjectMapper mapper, ByteBuffer byteBuffer, SmooshedFileMapper smooshedFiles) throws IOException {
            ColumnDescriptor serde = (ColumnDescriptor)mapper.readValue(serializerUtils.readString(byteBuffer), ColumnDescriptor.class);
            return serde.read(byteBuffer, this.columnConfig, smooshedFiles);
        }
    }

    static class LegacyIndexLoader
    implements IndexLoader {
        private final IndexIOHandler legacyHandler;
        private final ColumnConfig columnConfig;

        LegacyIndexLoader(IndexIOHandler legacyHandler, ColumnConfig columnConfig) {
            this.legacyHandler = legacyHandler;
            this.columnConfig = columnConfig;
        }

        @Override
        public QueryableIndex load(File inDir, ObjectMapper mapper) throws IOException {
            MMappedIndex index = this.legacyHandler.mapDir(inDir);
            HashMap<String, ColumnHolder> columns = new HashMap<String, ColumnHolder>();
            for (String dimension : index.getAvailableDimensions()) {
                ColumnBuilder builder = new ColumnBuilder().setType(ValueType.STRING).setHasMultipleValues(true).setDictionaryEncodedColumnSupplier(new DictionaryEncodedColumnSupplier(index.getDimValueLookup(dimension), null, (Supplier<ColumnarMultiInts>)Suppliers.ofInstance((Object)index.getDimColumn(dimension)), this.columnConfig.columnCacheSizeBytes())).setBitmapIndex(new BitmapIndexColumnPartSupplier(new ConciseBitmapFactory(), index.getBitmapIndexes().get(dimension), index.getDimValueLookup(dimension)));
                if (index.getSpatialIndexes().get(dimension) != null) {
                    builder.setSpatialIndex(new SpatialIndexColumnPartSupplier(index.getSpatialIndexes().get(dimension)));
                }
                columns.put(dimension, builder.build());
            }
            for (String metric : index.getAvailableMetrics()) {
                MetricHolder metricHolder = index.getMetricHolder(metric);
                if (metricHolder.getType() == MetricHolder.MetricType.FLOAT) {
                    columns.put(metric, new ColumnBuilder().setType(ValueType.FLOAT).setNumericColumnSupplier(new FloatNumericColumnSupplier(metricHolder.floatType, LEGACY_FACTORY.getBitmapFactory().makeEmptyImmutableBitmap())).build());
                    continue;
                }
                if (metricHolder.getType() != MetricHolder.MetricType.COMPLEX) continue;
                columns.put(metric, new ColumnBuilder().setType(ValueType.COMPLEX).setComplexColumnSupplier(new ComplexColumnPartSupplier(metricHolder.getTypeName(), metricHolder.complexType)).build());
            }
            columns.put("__time", new ColumnBuilder().setType(ValueType.LONG).setNumericColumnSupplier(new LongNumericColumnSupplier(index.timestamps, LEGACY_FACTORY.getBitmapFactory().makeEmptyImmutableBitmap())).build());
            return new SimpleQueryableIndex(index.getDataInterval(), index.getAvailableDimensions(), new ConciseBitmapFactory(), columns, index.getFileMapper(), null);
        }
    }

    static interface IndexLoader {
        public QueryableIndex load(File var1, ObjectMapper var2) throws IOException;
    }

    public static class DefaultIndexIOHandler
    implements IndexIOHandler {
        private static final Logger log = new Logger(DefaultIndexIOHandler.class);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MMappedIndex mapDir(File inDir) throws IOException {
            log.debug("Mapping v8 index[%s]", new Object[]{inDir});
            long startTime = System.currentTimeMillis();
            FileInputStream indexIn = null;
            try {
                indexIn = new FileInputStream(new File(inDir, "index.drd"));
                byte theVersion = (byte)((InputStream)indexIn).read();
                if (theVersion != 8) {
                    throw new IAE("Unknown version[%d]", new Object[]{theVersion});
                }
            }
            catch (Throwable throwable) {
                Closeables.close(indexIn, (boolean)false);
                throw throwable;
            }
            Closeables.close((Closeable)indexIn, (boolean)false);
            SmooshedFileMapper smooshedFiles = Smoosh.map((File)inDir);
            ByteBuffer indexBuffer = smooshedFiles.mapFile("index.drd");
            indexBuffer.get();
            GenericIndexed<String> availableDimensions = GenericIndexed.read(indexBuffer, GenericIndexed.STRING_STRATEGY, smooshedFiles);
            GenericIndexed<String> availableMetrics = GenericIndexed.read(indexBuffer, GenericIndexed.STRING_STRATEGY, smooshedFiles);
            Interval dataInterval = Intervals.of((String)serializerUtils.readString(indexBuffer));
            BitmapSerde.LegacyBitmapSerdeFactory bitmapSerdeFactory = new BitmapSerde.LegacyBitmapSerdeFactory();
            CompressedColumnarLongsSupplier timestamps = CompressedColumnarLongsSupplier.fromByteBuffer(smooshedFiles.mapFile(IndexIO.makeTimeFile(inDir, BYTE_ORDER).getName()), BYTE_ORDER);
            LinkedHashMap metrics = Maps.newLinkedHashMap();
            for (String metric : availableMetrics) {
                String metricFilename;
                Object holder;
                if (!metric.equals(((MetricHolder)(holder = MetricHolder.fromByteBuffer(smooshedFiles.mapFile(metricFilename = IndexIO.makeMetricFile(inDir, metric, BYTE_ORDER).getName())))).getName())) {
                    throw new ISE("Metric[%s] loaded up metric[%s] from disk.  File names do matter.", new Object[]{metric, ((MetricHolder)holder).getName()});
                }
                metrics.put(metric, holder);
            }
            HashMap<String, GenericIndexed<String>> dimValueLookups = new HashMap<String, GenericIndexed<String>>();
            HashMap<String, VSizeColumnarMultiInts> dimColumns = new HashMap<String, VSizeColumnarMultiInts>();
            HashMap<String, GenericIndexed<ImmutableBitmap>> bitmaps = new HashMap<String, GenericIndexed<ImmutableBitmap>>();
            for (String dimension : IndexedIterable.create(availableDimensions)) {
                ByteBuffer dimBuffer = smooshedFiles.mapFile(IndexIO.makeDimFile(inDir, dimension).getName());
                String fileDimensionName = serializerUtils.readString(dimBuffer);
                Preconditions.checkState((boolean)dimension.equals(fileDimensionName), (String)"Dimension file[%s] has dimension[%s] in it!?", (Object[])new Object[]{IndexIO.makeDimFile(inDir, dimension), fileDimensionName});
                dimValueLookups.put(dimension, GenericIndexed.read(dimBuffer, GenericIndexed.STRING_STRATEGY));
                dimColumns.put(dimension, VSizeColumnarMultiInts.readFromByteBuffer(dimBuffer));
            }
            ByteBuffer invertedBuffer = smooshedFiles.mapFile("inverted.drd");
            for (int i = 0; i < availableDimensions.size(); ++i) {
                bitmaps.put(serializerUtils.readString(invertedBuffer), GenericIndexed.read(invertedBuffer, bitmapSerdeFactory.getObjectStrategy()));
            }
            HashMap<String, ImmutableRTree> spatialIndexed = new HashMap<String, ImmutableRTree>();
            ByteBuffer spatialBuffer = smooshedFiles.mapFile("spatial.drd");
            while (spatialBuffer != null && spatialBuffer.hasRemaining()) {
                spatialIndexed.put(serializerUtils.readString(spatialBuffer), (ImmutableRTree)new ImmutableRTreeObjectStrategy(bitmapSerdeFactory.getBitmapFactory()).fromByteBufferWithSize(spatialBuffer));
            }
            MMappedIndex retVal = new MMappedIndex(availableDimensions, availableMetrics, dataInterval, timestamps, metrics, dimValueLookups, dimColumns, bitmaps, spatialIndexed, smooshedFiles);
            log.debug("Mapped v8 index[%s] in %,d millis", new Object[]{inDir, System.currentTimeMillis() - startTime});
            return retVal;
        }
    }

    static interface IndexIOHandler {
        public MMappedIndex mapDir(File var1) throws IOException;
    }
}

