/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.primitives.Ints;
import com.google.inject.Inject;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.io.ZeroCopyByteArrayOutputStream;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.io.smoosh.SmooshedWriter;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.BaseProgressIndicator;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.DimensionMerger;
import org.apache.druid.segment.DimensionMergerV9;
import org.apache.druid.segment.DoubleColumnSerializer;
import org.apache.druid.segment.DoubleColumnSerializerV2;
import org.apache.druid.segment.FloatColumnSerializer;
import org.apache.druid.segment.FloatColumnSerializerV2;
import org.apache.druid.segment.ForwardingRowIterator;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.IndexableAdapter;
import org.apache.druid.segment.LongColumnSerializer;
import org.apache.druid.segment.LongColumnSerializerV2;
import org.apache.druid.segment.MergingRowIterator;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.ProgressIndicator;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexIndexableAdapter;
import org.apache.druid.segment.RowCombiningTimeAndDimsIterator;
import org.apache.druid.segment.RowPointer;
import org.apache.druid.segment.TimeAndDimsIterator;
import org.apache.druid.segment.TimeAndDimsPointer;
import org.apache.druid.segment.TransformableRowIterator;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexAdapter;
import org.apache.druid.segment.loading.MMappedQueryableSegmentizerFactory;
import org.apache.druid.segment.serde.ColumnPartSerde;
import org.apache.druid.segment.serde.ComplexColumnPartSerde;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;
import org.apache.druid.segment.serde.DoubleNumericColumnPartSerde;
import org.apache.druid.segment.serde.DoubleNumericColumnPartSerdeV2;
import org.apache.druid.segment.serde.FloatNumericColumnPartSerde;
import org.apache.druid.segment.serde.FloatNumericColumnPartSerdeV2;
import org.apache.druid.segment.serde.LongNumericColumnPartSerde;
import org.apache.druid.segment.serde.LongNumericColumnPartSerdeV2;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class IndexMergerV9
implements IndexMerger {
    private static final Logger log = new Logger(IndexMergerV9.class);
    private final ObjectMapper mapper;
    private final IndexIO indexIO;
    private final SegmentWriteOutMediumFactory defaultSegmentWriteOutMediumFactory;

    @Inject
    public IndexMergerV9(ObjectMapper mapper, IndexIO indexIO, SegmentWriteOutMediumFactory defaultSegmentWriteOutMediumFactory) {
        this.mapper = (ObjectMapper)Preconditions.checkNotNull((Object)mapper, (Object)"null ObjectMapper");
        this.indexIO = (IndexIO)Preconditions.checkNotNull((Object)indexIO, (Object)"null IndexIO");
        this.defaultSegmentWriteOutMediumFactory = (SegmentWriteOutMediumFactory)Preconditions.checkNotNull((Object)defaultSegmentWriteOutMediumFactory, (Object)"null SegmentWriteOutMediumFactory");
    }

    private File makeIndexFiles(List<IndexableAdapter> adapters, @Nullable AggregatorFactory[] metricAggs, File outDir, ProgressIndicator progress, List<String> mergedDimensions, List<String> mergedMetrics, Function<List<TransformableRowIterator>, TimeAndDimsIterator> rowMergerFn, boolean fillRowNumConversions, IndexSpec indexSpec, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
        Metadata segmentMetadata;
        progress.start();
        progress.progress();
        List metadataList = Lists.transform(adapters, IndexableAdapter::getMetadata);
        if (metricAggs != null) {
            AggregatorFactory[] combiningMetricAggs = new AggregatorFactory[metricAggs.length];
            for (int i = 0; i < metricAggs.length; ++i) {
                combiningMetricAggs[i] = metricAggs[i].getCombiningFactory();
            }
            segmentMetadata = Metadata.merge(metadataList, combiningMetricAggs);
        } else {
            segmentMetadata = Metadata.merge(metadataList, null);
        }
        try (Closer closer = Closer.create();){
            FileSmoosher v9Smoosher = new FileSmoosher(outDir);
            FileUtils.forceMkdir((File)outDir);
            SegmentWriteOutMediumFactory omf = segmentWriteOutMediumFactory != null ? segmentWriteOutMediumFactory : this.defaultSegmentWriteOutMediumFactory;
            log.info("Using SegmentWriteOutMediumFactory[%s]", new Object[]{omf.getClass().getSimpleName()});
            SegmentWriteOutMedium segmentWriteOutMedium = omf.makeSegmentWriteOutMedium(outDir);
            closer.register((Closeable)segmentWriteOutMedium);
            long startTime = System.currentTimeMillis();
            Files.asByteSink((File)new File(outDir, "version.bin"), (FileWriteMode[])new FileWriteMode[0]).write(Ints.toByteArray((int)9));
            log.info("Completed version.bin in %,d millis.", new Object[]{System.currentTimeMillis() - startTime});
            progress.progress();
            startTime = System.currentTimeMillis();
            try (FileOutputStream fos = new FileOutputStream(new File(outDir, "factory.json"));){
                this.mapper.writeValue((OutputStream)fos, (Object)new MMappedQueryableSegmentizerFactory(this.indexIO));
            }
            log.info("Completed factory.json in %,d millis", new Object[]{System.currentTimeMillis() - startTime});
            progress.progress();
            TreeMap<String, ValueType> metricsValueTypes = new TreeMap<String, ValueType>((Comparator<String>)Comparators.naturalNullsFirst());
            TreeMap<String, String> metricTypeNames = new TreeMap<String, String>((Comparator<String>)Comparators.naturalNullsFirst());
            ArrayList dimCapabilities = Lists.newArrayListWithCapacity((int)mergedDimensions.size());
            this.mergeCapabilities(adapters, mergedDimensions, metricsValueTypes, metricTypeNames, dimCapabilities);
            Map<String, DimensionHandler> handlers = this.makeDimensionHandlers(mergedDimensions, dimCapabilities);
            ArrayList<DimensionMergerV9> mergers = new ArrayList<DimensionMergerV9>();
            for (int i = 0; i < mergedDimensions.size(); ++i) {
                DimensionHandler handler = handlers.get(mergedDimensions.get(i));
                mergers.add(handler.makeMerger(indexSpec, segmentWriteOutMedium, (ColumnCapabilities)dimCapabilities.get(i), progress, closer));
            }
            progress.progress();
            startTime = System.currentTimeMillis();
            this.writeDimValuesAndSetupDimConversion(adapters, progress, mergedDimensions, mergers);
            log.info("Completed dim conversions in %,d millis.", new Object[]{System.currentTimeMillis() - startTime});
            progress.progress();
            TimeAndDimsIterator timeAndDimsIterator = this.makeMergedTimeAndDimsIterator(adapters, mergedDimensions, mergedMetrics, rowMergerFn, handlers, mergers);
            closer.register((Closeable)timeAndDimsIterator);
            GenericColumnSerializer timeWriter = this.setupTimeWriter(segmentWriteOutMedium, indexSpec);
            ArrayList<GenericColumnSerializer> metricWriters = this.setupMetricsWriters(segmentWriteOutMedium, mergedMetrics, metricsValueTypes, metricTypeNames, indexSpec);
            List<IntBuffer> rowNumConversions = this.mergeIndexesAndWriteColumns(adapters, progress, timeAndDimsIterator, timeWriter, metricWriters, mergers, fillRowNumConversions);
            String section = "build inverted index and columns";
            progress.startSection("build inverted index and columns");
            this.makeTimeColumn(v9Smoosher, progress, timeWriter, indexSpec);
            this.makeMetricsColumns(v9Smoosher, progress, mergedMetrics, metricsValueTypes, metricTypeNames, metricWriters, indexSpec);
            for (int i = 0; i < mergedDimensions.size(); ++i) {
                DimensionMergerV9 merger = (DimensionMergerV9)mergers.get(i);
                merger.writeIndexes(rowNumConversions);
                if (merger.canSkip()) continue;
                ColumnDescriptor columnDesc = merger.makeColumnDescriptor();
                this.makeColumn(v9Smoosher, mergedDimensions.get(i), columnDesc);
            }
            progress.stopSection("build inverted index and columns");
            progress.progress();
            this.makeIndexBinary(v9Smoosher, adapters, outDir, mergedDimensions, mergedMetrics, progress, indexSpec, mergers);
            this.makeMetadataBinary(v9Smoosher, progress, segmentMetadata);
            v9Smoosher.close();
            progress.stop();
            File file = outDir;
            return file;
        }
    }

    private void makeMetadataBinary(FileSmoosher v9Smoosher, ProgressIndicator progress, Metadata segmentMetadata) throws IOException {
        if (segmentMetadata != null) {
            progress.startSection("make metadata.drd");
            v9Smoosher.add("metadata.drd", ByteBuffer.wrap(this.mapper.writeValueAsBytes((Object)segmentMetadata)));
            progress.stopSection("make metadata.drd");
        }
    }

    private void makeIndexBinary(FileSmoosher v9Smoosher, List<IndexableAdapter> adapters, File outDir, List<String> mergedDimensions, List<String> mergedMetrics, ProgressIndicator progress, IndexSpec indexSpec, List<DimensionMergerV9> mergers) throws IOException {
        String section = "make index.drd";
        progress.startSection("make index.drd");
        long startTime = System.currentTimeMillis();
        LinkedHashSet<String> finalDimensions = new LinkedHashSet<String>();
        LinkedHashSet<String> finalColumns = new LinkedHashSet<String>();
        finalColumns.addAll(mergedMetrics);
        for (int i = 0; i < mergedDimensions.size(); ++i) {
            if (mergers.get(i).canSkip()) continue;
            finalColumns.add(mergedDimensions.get(i));
            finalDimensions.add(mergedDimensions.get(i));
        }
        GenericIndexed<String> cols = GenericIndexed.fromIterable(finalColumns, GenericIndexed.STRING_STRATEGY);
        GenericIndexed<String> dims = GenericIndexed.fromIterable(finalDimensions, GenericIndexed.STRING_STRATEGY);
        String bitmapSerdeFactoryType = this.mapper.writeValueAsString((Object)indexSpec.getBitmapSerdeFactory());
        long numBytes = cols.getSerializedSize() + dims.getSerializedSize() + 16L + (long)serializerUtils.getSerializedStringByteSize(bitmapSerdeFactoryType);
        SmooshedWriter writer = v9Smoosher.addWithSmooshedWriter("index.drd", numBytes);
        cols.writeTo((WritableByteChannel)writer, v9Smoosher);
        dims.writeTo((WritableByteChannel)writer, v9Smoosher);
        DateTime minTime = DateTimes.MAX;
        DateTime maxTime = DateTimes.MIN;
        for (IndexableAdapter index : adapters) {
            minTime = JodaUtils.minDateTime((DateTime[])new DateTime[]{minTime, index.getDataInterval().getStart()});
            maxTime = JodaUtils.maxDateTime((DateTime[])new DateTime[]{maxTime, index.getDataInterval().getEnd()});
        }
        Interval dataInterval = new Interval((ReadableInstant)minTime, (ReadableInstant)maxTime);
        serializerUtils.writeLong((WritableByteChannel)writer, dataInterval.getStartMillis());
        serializerUtils.writeLong((WritableByteChannel)writer, dataInterval.getEndMillis());
        serializerUtils.writeString((WritableByteChannel)writer, bitmapSerdeFactoryType);
        writer.close();
        IndexIO.checkFileSize(new File(outDir, "index.drd"));
        log.info("Completed index.drd in %,d millis.", new Object[]{System.currentTimeMillis() - startTime});
        progress.stopSection("make index.drd");
    }

    private void makeMetricsColumns(FileSmoosher v9Smoosher, ProgressIndicator progress, List<String> mergedMetrics, Map<String, ValueType> metricsValueTypes, Map<String, String> metricTypeNames, List<GenericColumnSerializer> metWriters, IndexSpec indexSpec) throws IOException {
        String section = "make metric columns";
        progress.startSection("make metric columns");
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < mergedMetrics.size(); ++i) {
            String metric = mergedMetrics.get(i);
            long metricStartTime = System.currentTimeMillis();
            GenericColumnSerializer writer = metWriters.get(i);
            ColumnDescriptor.Builder builder = ColumnDescriptor.builder();
            ValueType type = metricsValueTypes.get(metric);
            switch (type) {
                case LONG: {
                    builder.setValueType(ValueType.LONG);
                    builder.addSerde(IndexMergerV9.createLongColumnPartSerde(writer, indexSpec));
                    break;
                }
                case FLOAT: {
                    builder.setValueType(ValueType.FLOAT);
                    builder.addSerde(IndexMergerV9.createFloatColumnPartSerde(writer, indexSpec));
                    break;
                }
                case DOUBLE: {
                    builder.setValueType(ValueType.DOUBLE);
                    builder.addSerde(IndexMergerV9.createDoubleColumnPartSerde(writer, indexSpec));
                    break;
                }
                case COMPLEX: {
                    String typeName = metricTypeNames.get(metric);
                    builder.setValueType(ValueType.COMPLEX);
                    builder.addSerde(ComplexColumnPartSerde.serializerBuilder().withTypeName(typeName).withDelegate(writer).build());
                    break;
                }
                default: {
                    throw new ISE("Unknown type[%s]", new Object[]{type});
                }
            }
            this.makeColumn(v9Smoosher, metric, builder.build());
            log.info("Completed metric column[%s] in %,d millis.", new Object[]{metric, System.currentTimeMillis() - metricStartTime});
        }
        log.info("Completed metric columns in %,d millis.", new Object[]{System.currentTimeMillis() - startTime});
        progress.stopSection("make metric columns");
    }

    static ColumnPartSerde createLongColumnPartSerde(GenericColumnSerializer serializer, IndexSpec indexSpec) {
        if (NullHandling.replaceWithDefault()) {
            return LongNumericColumnPartSerde.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withDelegate(serializer).build();
        }
        return LongNumericColumnPartSerdeV2.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withBitmapSerdeFactory(indexSpec.getBitmapSerdeFactory()).withDelegate(serializer).build();
    }

    static ColumnPartSerde createDoubleColumnPartSerde(GenericColumnSerializer serializer, IndexSpec indexSpec) {
        if (NullHandling.replaceWithDefault()) {
            return DoubleNumericColumnPartSerde.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withDelegate(serializer).build();
        }
        return DoubleNumericColumnPartSerdeV2.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withBitmapSerdeFactory(indexSpec.getBitmapSerdeFactory()).withDelegate(serializer).build();
    }

    static ColumnPartSerde createFloatColumnPartSerde(GenericColumnSerializer serializer, IndexSpec indexSpec) {
        if (NullHandling.replaceWithDefault()) {
            return FloatNumericColumnPartSerde.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withDelegate(serializer).build();
        }
        return FloatNumericColumnPartSerdeV2.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withBitmapSerdeFactory(indexSpec.getBitmapSerdeFactory()).withDelegate(serializer).build();
    }

    private void makeTimeColumn(FileSmoosher v9Smoosher, ProgressIndicator progress, GenericColumnSerializer timeWriter, IndexSpec indexSpec) throws IOException {
        String section = "make time column";
        progress.startSection("make time column");
        long startTime = System.currentTimeMillis();
        ColumnDescriptor serdeficator = ColumnDescriptor.builder().setValueType(ValueType.LONG).addSerde(IndexMergerV9.createLongColumnPartSerde(timeWriter, indexSpec)).build();
        this.makeColumn(v9Smoosher, "__time", serdeficator);
        log.info("Completed time column in %,d millis.", new Object[]{System.currentTimeMillis() - startTime});
        progress.stopSection("make time column");
    }

    private void makeColumn(FileSmoosher v9Smoosher, String columnName, ColumnDescriptor serdeficator) throws IOException {
        ZeroCopyByteArrayOutputStream specBytes = new ZeroCopyByteArrayOutputStream();
        serializerUtils.writeString((OutputStream)specBytes, this.mapper.writeValueAsString((Object)serdeficator));
        try (SmooshedWriter channel = v9Smoosher.addWithSmooshedWriter(columnName, (long)specBytes.size() + serdeficator.getSerializedSize());){
            specBytes.writeTo((WritableByteChannel)channel);
            serdeficator.writeTo((WritableByteChannel)channel, v9Smoosher);
        }
    }

    @Nullable
    private List<IntBuffer> mergeIndexesAndWriteColumns(List<IndexableAdapter> adapters, ProgressIndicator progress, TimeAndDimsIterator timeAndDimsIterator, GenericColumnSerializer timeWriter, ArrayList<GenericColumnSerializer> metricWriters, List<DimensionMergerV9> mergers, boolean fillRowNumConversions) throws IOException {
        String section = "walk through and merge rows";
        progress.startSection("walk through and merge rows");
        long startTime = System.currentTimeMillis();
        ArrayList<IntBuffer> rowNumConversions = null;
        int rowCount = 0;
        if (fillRowNumConversions) {
            rowNumConversions = new ArrayList<IntBuffer>(adapters.size());
            for (IndexableAdapter adapter : adapters) {
                int[] arr = new int[adapter.getNumRows()];
                Arrays.fill(arr, -1);
                rowNumConversions.add(IntBuffer.wrap(arr));
            }
        }
        long time = System.currentTimeMillis();
        while (timeAndDimsIterator.moveToNext()) {
            progress.progress();
            TimeAndDimsPointer timeAndDims = timeAndDimsIterator.getPointer();
            timeWriter.serialize(timeAndDims.timestampSelector);
            for (int metricIndex = 0; metricIndex < timeAndDims.getNumMetrics(); ++metricIndex) {
                metricWriters.get(metricIndex).serialize(timeAndDims.getMetricSelector(metricIndex));
            }
            for (int dimIndex = 0; dimIndex < timeAndDims.getNumDimensions(); ++dimIndex) {
                DimensionMerger merger = mergers.get(dimIndex);
                if (merger.canSkip()) continue;
                merger.processMergedRow(timeAndDims.getDimensionSelector(dimIndex));
            }
            if (timeAndDimsIterator instanceof RowCombiningTimeAndDimsIterator) {
                RowCombiningTimeAndDimsIterator comprisedRows = (RowCombiningTimeAndDimsIterator)timeAndDimsIterator;
                int originalIteratorIndex = comprisedRows.nextCurrentlyCombinedOriginalIteratorIndex(0);
                while (originalIteratorIndex >= 0) {
                    IntBuffer conversionBuffer = (IntBuffer)rowNumConversions.get(originalIteratorIndex);
                    int minRowNum = comprisedRows.getMinCurrentlyCombinedRowNumByOriginalIteratorIndex(originalIteratorIndex);
                    int maxRowNum = comprisedRows.getMaxCurrentlyCombinedRowNumByOriginalIteratorIndex(originalIteratorIndex);
                    for (int rowNum = minRowNum; rowNum <= maxRowNum; ++rowNum) {
                        while (conversionBuffer.position() < rowNum) {
                            conversionBuffer.put(-1);
                        }
                        conversionBuffer.put(rowCount);
                    }
                    originalIteratorIndex = comprisedRows.nextCurrentlyCombinedOriginalIteratorIndex(originalIteratorIndex + 1);
                }
            } else if (timeAndDimsIterator instanceof MergingRowIterator) {
                RowPointer rowPointer = (RowPointer)timeAndDims;
                IntBuffer conversionBuffer = (IntBuffer)rowNumConversions.get(rowPointer.getIndexNum());
                int rowNum = rowPointer.getRowNum();
                while (conversionBuffer.position() < rowNum) {
                    conversionBuffer.put(-1);
                }
                conversionBuffer.put(rowCount);
            } else if (fillRowNumConversions) {
                throw new IllegalStateException("Filling row num conversions is supported only with RowCombining and Merging iterators");
            }
            if (++rowCount % 500000 != 0) continue;
            log.info("walked 500,000/%d rows in %,d millis.", new Object[]{rowCount, System.currentTimeMillis() - time});
            time = System.currentTimeMillis();
        }
        if (rowNumConversions != null) {
            for (IntBuffer rowNumConversion : rowNumConversions) {
                rowNumConversion.rewind();
            }
        }
        log.info("completed walk through of %,d rows in %,d millis.", new Object[]{rowCount, System.currentTimeMillis() - startTime});
        progress.stopSection("walk through and merge rows");
        return rowNumConversions;
    }

    private GenericColumnSerializer setupTimeWriter(SegmentWriteOutMedium segmentWriteOutMedium, IndexSpec indexSpec) throws IOException {
        GenericColumnSerializer timeWriter = IndexMergerV9.createLongColumnSerializer(segmentWriteOutMedium, "little_end_time", indexSpec);
        timeWriter.open();
        return timeWriter;
    }

    private ArrayList<GenericColumnSerializer> setupMetricsWriters(SegmentWriteOutMedium segmentWriteOutMedium, List<String> mergedMetrics, Map<String, ValueType> metricsValueTypes, Map<String, String> metricTypeNames, IndexSpec indexSpec) throws IOException {
        ArrayList metWriters = Lists.newArrayListWithCapacity((int)mergedMetrics.size());
        for (String metric : mergedMetrics) {
            GenericColumnSerializer writer;
            ValueType type = metricsValueTypes.get(metric);
            switch (type) {
                case LONG: {
                    writer = IndexMergerV9.createLongColumnSerializer(segmentWriteOutMedium, metric, indexSpec);
                    break;
                }
                case FLOAT: {
                    writer = IndexMergerV9.createFloatColumnSerializer(segmentWriteOutMedium, metric, indexSpec);
                    break;
                }
                case DOUBLE: {
                    writer = IndexMergerV9.createDoubleColumnSerializer(segmentWriteOutMedium, metric, indexSpec);
                    break;
                }
                case COMPLEX: {
                    String typeName = metricTypeNames.get(metric);
                    ComplexMetricSerde serde = ComplexMetrics.getSerdeForType(typeName);
                    if (serde == null) {
                        throw new ISE("Unknown type[%s]", new Object[]{typeName});
                    }
                    writer = serde.getSerializer(segmentWriteOutMedium, metric);
                    break;
                }
                default: {
                    throw new ISE("Unknown type[%s]", new Object[]{type});
                }
            }
            writer.open();
            metWriters.add(writer);
        }
        return metWriters;
    }

    static GenericColumnSerializer createLongColumnSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String columnName, IndexSpec indexSpec) {
        if (NullHandling.replaceWithDefault()) {
            return LongColumnSerializer.create(segmentWriteOutMedium, columnName, indexSpec.getMetricCompression(), indexSpec.getLongEncoding());
        }
        return LongColumnSerializerV2.create(segmentWriteOutMedium, columnName, indexSpec.getMetricCompression(), indexSpec.getLongEncoding(), indexSpec.getBitmapSerdeFactory());
    }

    static GenericColumnSerializer createDoubleColumnSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String columnName, IndexSpec indexSpec) {
        if (NullHandling.replaceWithDefault()) {
            return DoubleColumnSerializer.create(segmentWriteOutMedium, columnName, indexSpec.getMetricCompression());
        }
        return DoubleColumnSerializerV2.create(segmentWriteOutMedium, columnName, indexSpec.getMetricCompression(), indexSpec.getBitmapSerdeFactory());
    }

    static GenericColumnSerializer createFloatColumnSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String columnName, IndexSpec indexSpec) {
        if (NullHandling.replaceWithDefault()) {
            return FloatColumnSerializer.create(segmentWriteOutMedium, columnName, indexSpec.getMetricCompression());
        }
        return FloatColumnSerializerV2.create(segmentWriteOutMedium, columnName, indexSpec.getMetricCompression(), indexSpec.getBitmapSerdeFactory());
    }

    private void writeDimValuesAndSetupDimConversion(List<IndexableAdapter> indexes, ProgressIndicator progress, List<String> mergedDimensions, List<DimensionMergerV9> mergers) throws IOException {
        String section = "setup dimension conversions";
        progress.startSection("setup dimension conversions");
        for (int dimIndex = 0; dimIndex < mergedDimensions.size(); ++dimIndex) {
            mergers.get(dimIndex).writeMergedValueDictionary(indexes);
        }
        progress.stopSection("setup dimension conversions");
    }

    private void mergeCapabilities(List<IndexableAdapter> adapters, List<String> mergedDimensions, Map<String, ValueType> metricsValueTypes, Map<String, String> metricTypeNames, List<ColumnCapabilitiesImpl> dimCapabilities) {
        HashMap<String, ColumnCapabilitiesImpl> capabilitiesMap = new HashMap<String, ColumnCapabilitiesImpl>();
        for (IndexableAdapter adapter : adapters) {
            ColumnCapabilities capabilities;
            for (String dimension : adapter.getDimensionNames()) {
                capabilities = adapter.getCapabilities(dimension);
                capabilitiesMap.computeIfAbsent(dimension, d -> new ColumnCapabilitiesImpl()).merge(capabilities);
            }
            for (String metric : adapter.getMetricNames()) {
                capabilities = adapter.getCapabilities(metric);
                capabilitiesMap.computeIfAbsent(metric, m -> new ColumnCapabilitiesImpl()).merge(capabilities);
                metricsValueTypes.put(metric, capabilities.getType());
                metricTypeNames.put(metric, adapter.getMetricType(metric));
            }
        }
        for (String dim : mergedDimensions) {
            dimCapabilities.add((ColumnCapabilitiesImpl)capabilitiesMap.get(dim));
        }
    }

    @Override
    public File persist(IncrementalIndex index, File outDir, IndexSpec indexSpec, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
        return this.persist(index, index.getInterval(), outDir, indexSpec, segmentWriteOutMediumFactory);
    }

    @Override
    public File persist(IncrementalIndex index, Interval dataInterval, File outDir, IndexSpec indexSpec, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
        return this.persist(index, dataInterval, outDir, indexSpec, new BaseProgressIndicator(), segmentWriteOutMediumFactory);
    }

    @Override
    public File persist(IncrementalIndex index, Interval dataInterval, File outDir, IndexSpec indexSpec, ProgressIndicator progress, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
        if (index.isEmpty()) {
            throw new IAE("Trying to persist an empty index!", new Object[0]);
        }
        DateTime firstTimestamp = index.getMinTime();
        DateTime lastTimestamp = index.getMaxTime();
        if (!dataInterval.contains((ReadableInstant)firstTimestamp) || !dataInterval.contains((ReadableInstant)lastTimestamp)) {
            throw new IAE("interval[%s] does not encapsulate the full range of timestamps[%s, %s]", new Object[]{dataInterval, firstTimestamp, lastTimestamp});
        }
        FileUtils.forceMkdir((File)outDir);
        log.info("Starting persist for interval[%s], rows[%,d]", new Object[]{dataInterval, index.size()});
        return this.merge(Collections.singletonList(new IncrementalIndexAdapter(dataInterval, index, indexSpec.getBitmapSerdeFactory().getBitmapFactory())), false, index.getMetricAggs(), outDir, indexSpec, progress, segmentWriteOutMediumFactory);
    }

    @Override
    public File mergeQueryableIndex(List<QueryableIndex> indexes, boolean rollup, AggregatorFactory[] metricAggs, File outDir, IndexSpec indexSpec, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
        return this.mergeQueryableIndex(indexes, rollup, metricAggs, outDir, indexSpec, new BaseProgressIndicator(), segmentWriteOutMediumFactory);
    }

    @Override
    public File mergeQueryableIndex(List<QueryableIndex> indexes, boolean rollup, AggregatorFactory[] metricAggs, File outDir, IndexSpec indexSpec, ProgressIndicator progress, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
        return this.merge(IndexMerger.toIndexableAdapters(indexes), rollup, metricAggs, outDir, indexSpec, progress, segmentWriteOutMediumFactory);
    }

    @Override
    public File merge(List<IndexableAdapter> indexes, boolean rollup, AggregatorFactory[] metricAggs, File outDir, IndexSpec indexSpec) throws IOException {
        return this.merge(indexes, rollup, metricAggs, outDir, indexSpec, new BaseProgressIndicator(), null);
    }

    private File merge(List<IndexableAdapter> indexes, boolean rollup, AggregatorFactory[] metricAggs, File outDir, IndexSpec indexSpec, ProgressIndicator progress, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
        int i;
        FileUtils.deleteDirectory((File)outDir);
        FileUtils.forceMkdir((File)outDir);
        List<String> mergedDimensions = IndexMerger.getMergedDimensions(indexes);
        ArrayList<String> mergedMetrics = IndexMerger.mergeIndexed(indexes.stream().map(IndexableAdapter::getMetricNames).collect(Collectors.toList()));
        AggregatorFactory[] sortedMetricAggs = new AggregatorFactory[mergedMetrics.size()];
        for (AggregatorFactory metricAgg : metricAggs) {
            int metricIndex = mergedMetrics.indexOf(metricAgg.getName());
            if (metricIndex <= -1) continue;
            sortedMetricAggs[metricIndex] = metricAgg;
        }
        for (i = 0; i < sortedMetricAggs.length; ++i) {
            if (sortedMetricAggs[i] != null) continue;
            throw new IAE("Indices to merge contained metric[%s], but requested metrics did not", new Object[]{mergedMetrics.get(i)});
        }
        for (i = 0; i < mergedMetrics.size(); ++i) {
            if (sortedMetricAggs[i].getName().equals(mergedMetrics.get(i))) continue;
            throw new IAE("Metric mismatch, index[%d] [%s] != [%s]", new Object[]{i, sortedMetricAggs[i].getName(), mergedMetrics.get(i)});
        }
        Function<List<TransformableRowIterator>, TimeAndDimsIterator> rowMergerFn = rollup ? rowIterators -> new RowCombiningTimeAndDimsIterator((List<TransformableRowIterator>)rowIterators, sortedMetricAggs, (List<String>)mergedMetrics) : MergingRowIterator::new;
        return this.makeIndexFiles(indexes, sortedMetricAggs, outDir, progress, mergedDimensions, mergedMetrics, rowMergerFn, true, indexSpec, segmentWriteOutMediumFactory);
    }

    @Override
    public File convert(File inDir, File outDir, IndexSpec indexSpec) throws IOException {
        return this.convert(inDir, outDir, indexSpec, new BaseProgressIndicator(), this.defaultSegmentWriteOutMediumFactory);
    }

    @Override
    public File convert(File inDir, File outDir, IndexSpec indexSpec, ProgressIndicator progress, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
        try (QueryableIndex index = this.indexIO.loadIndex(inDir);){
            QueryableIndexIndexableAdapter adapter = new QueryableIndexIndexableAdapter(index);
            File file = this.makeIndexFiles((List<IndexableAdapter>)ImmutableList.of((Object)adapter), null, outDir, progress, Lists.newArrayList(adapter.getDimensionNames()), Lists.newArrayList(adapter.getMetricNames()), Iterables::getOnlyElement, false, indexSpec, segmentWriteOutMediumFactory);
            return file;
        }
    }

    @Override
    public File append(List<IndexableAdapter> indexes, AggregatorFactory[] aggregators, File outDir, IndexSpec indexSpec, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
        FileUtils.deleteDirectory((File)outDir);
        FileUtils.forceMkdir((File)outDir);
        List<String> mergedDimensions = IndexMerger.getMergedDimensions(indexes);
        ArrayList<String> mergedMetrics = IndexMerger.mergeIndexed(indexes.stream().map(IndexableAdapter::getMetricNames).collect(Collectors.toList()));
        return this.makeIndexFiles(indexes, aggregators, outDir, new BaseProgressIndicator(), mergedDimensions, mergedMetrics, MergingRowIterator::new, true, indexSpec, segmentWriteOutMediumFactory);
    }

    private Map<String, DimensionHandler> makeDimensionHandlers(List<String> mergedDimensions, List<ColumnCapabilitiesImpl> dimCapabilities) {
        LinkedHashMap<String, DimensionHandler> handlers = new LinkedHashMap<String, DimensionHandler>();
        for (int i = 0; i < mergedDimensions.size(); ++i) {
            ColumnCapabilities capabilities = dimCapabilities.get(i);
            String dimName = mergedDimensions.get(i);
            DimensionHandler handler = DimensionHandlerUtils.getHandlerFromCapabilities(dimName, capabilities, null);
            handlers.put(dimName, handler);
        }
        return handlers;
    }

    private TimeAndDimsIterator makeMergedTimeAndDimsIterator(List<IndexableAdapter> indexes, List<String> mergedDimensions, List<String> mergedMetrics, Function<List<TransformableRowIterator>, TimeAndDimsIterator> rowMergerFn, Map<String, DimensionHandler> handlers, List<DimensionMergerV9> mergers) {
        ArrayList perIndexRowIterators = Lists.newArrayListWithCapacity((int)indexes.size());
        for (int i = 0; i < indexes.size(); ++i) {
            IndexableAdapter adapter = indexes.get(i);
            TransformableRowIterator target = adapter.getRows();
            if (!mergedDimensions.equals(adapter.getDimensionNames()) || !mergedMetrics.equals(adapter.getMetricNames())) {
                target = this.makeRowIteratorWithReorderedColumns(mergedDimensions, mergedMetrics, handlers, adapter, target);
            }
            perIndexRowIterators.add(IndexMerger.toMergedIndexRowIterator(target, i, mergers));
        }
        return rowMergerFn.apply(perIndexRowIterators);
    }

    private TransformableRowIterator makeRowIteratorWithReorderedColumns(List<String> reorderedDimensions, List<String> reorderedMetrics, Map<String, DimensionHandler> originalHandlers, IndexableAdapter originalAdapter, TransformableRowIterator originalIterator) {
        final RowPointer reorderedRowPointer = IndexMergerV9.reorderRowPointerColumns(reorderedDimensions, reorderedMetrics, originalHandlers, originalAdapter, originalIterator.getPointer());
        final TimeAndDimsPointer reorderedMarkedRowPointer = IndexMergerV9.reorderRowPointerColumns(reorderedDimensions, reorderedMetrics, originalHandlers, originalAdapter, originalIterator.getMarkedPointer());
        return new ForwardingRowIterator(originalIterator){

            @Override
            public RowPointer getPointer() {
                return reorderedRowPointer;
            }

            @Override
            public TimeAndDimsPointer getMarkedPointer() {
                return reorderedMarkedRowPointer;
            }
        };
    }

    private static <T extends TimeAndDimsPointer> T reorderRowPointerColumns(List<String> reorderedDimensions, List<String> reorderedMetrics, Map<String, DimensionHandler> originalHandlers, IndexableAdapter originalAdapter, T originalRowPointer) {
        ColumnValueSelector[] reorderedDimensionSelectors = (ColumnValueSelector[])reorderedDimensions.stream().map(dimName -> {
            int dimIndex = originalAdapter.getDimensionNames().indexOf(dimName);
            if (dimIndex >= 0) {
                return originalRowPointer.getDimensionSelector(dimIndex);
            }
            return NilColumnValueSelector.instance();
        }).toArray(ColumnValueSelector[]::new);
        List<DimensionHandler> reorderedHandlers = reorderedDimensions.stream().map(originalHandlers::get).collect(Collectors.toList());
        ColumnValueSelector[] reorderedMetricSelectors = (ColumnValueSelector[])reorderedMetrics.stream().map(metricName -> {
            int metricIndex = originalAdapter.getMetricNames().indexOf(metricName);
            if (metricIndex >= 0) {
                return originalRowPointer.getMetricSelector(metricIndex);
            }
            return NilColumnValueSelector.instance();
        }).toArray(ColumnValueSelector[]::new);
        if (originalRowPointer instanceof RowPointer) {
            return (T)new RowPointer(originalRowPointer.timestampSelector, reorderedDimensionSelectors, reorderedHandlers, reorderedMetricSelectors, reorderedMetrics, ((RowPointer)originalRowPointer).rowNumPointer);
        }
        return (T)new TimeAndDimsPointer(originalRowPointer.timestampSelector, reorderedDimensionSelectors, reorderedHandlers, reorderedMetricSelectors, reorderedMetrics);
    }
}

