/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.DefaultBitmapResultFactory;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BitmapOffset;
import org.apache.druid.segment.Capabilities;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorBitmapIndexSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.FilteredOffset;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexColumnSelectorFactory;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.SimpleDescendingOffset;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.BitmapIndex;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ComplexColumn;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.NumericColumn;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.Offset;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.filter.AndFilter;
import org.apache.druid.segment.historical.HistoricalCursor;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class QueryableIndexStorageAdapter
implements StorageAdapter {
    private final QueryableIndex index;

    public QueryableIndexStorageAdapter(QueryableIndex index) {
        this.index = index;
    }

    @Override
    public String getSegmentIdentifier() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Interval getInterval() {
        return this.index.getDataInterval();
    }

    @Override
    public Indexed<String> getAvailableDimensions() {
        return this.index.getAvailableDimensions();
    }

    @Override
    public Iterable<String> getAvailableMetrics() {
        HashSet columnNames = Sets.newHashSet(this.index.getColumnNames());
        return Sets.difference((Set)columnNames, (Set)Sets.newHashSet(this.index.getAvailableDimensions()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getDimensionCardinality(String dimension) {
        ColumnHolder columnHolder = this.index.getColumnHolder(dimension);
        if (columnHolder == null) {
            return 0;
        }
        try (BaseColumn col = columnHolder.getColumn();){
            if (!(col instanceof DictionaryEncodedColumn)) {
                int n = Integer.MAX_VALUE;
                return n;
            }
            int n = ((DictionaryEncodedColumn)col).getCardinality();
            return n;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public int getNumRows() {
        return this.index.getNumRows();
    }

    @Override
    public DateTime getMinTime() {
        try (NumericColumn column = (NumericColumn)this.index.getColumnHolder("__time").getColumn();){
            DateTime dateTime = DateTimes.utc((long)column.getLongSingleValueRow(0));
            return dateTime;
        }
    }

    @Override
    public DateTime getMaxTime() {
        try (NumericColumn column = (NumericColumn)this.index.getColumnHolder("__time").getColumn();){
            DateTime dateTime = DateTimes.utc((long)column.getLongSingleValueRow(column.length() - 1));
            return dateTime;
        }
    }

    @Override
    @Nullable
    public Comparable getMinValue(String dimension) {
        ColumnHolder columnHolder = this.index.getColumnHolder(dimension);
        if (columnHolder != null && columnHolder.getCapabilities().hasBitmapIndexes()) {
            BitmapIndex bitmap = columnHolder.getBitmapIndex();
            return bitmap.getCardinality() > 0 ? bitmap.getValue(0) : null;
        }
        return null;
    }

    @Override
    @Nullable
    public Comparable getMaxValue(String dimension) {
        ColumnHolder columnHolder = this.index.getColumnHolder(dimension);
        if (columnHolder != null && columnHolder.getCapabilities().hasBitmapIndexes()) {
            BitmapIndex bitmap = columnHolder.getBitmapIndex();
            return bitmap.getCardinality() > 0 ? bitmap.getValue(bitmap.getCardinality() - 1) : null;
        }
        return null;
    }

    @Override
    public Capabilities getCapabilities() {
        return Capabilities.builder().dimensionValuesSorted(true).build();
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        return QueryableIndexStorageAdapter.getColumnCapabilities(this.index, column);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getColumnTypeName(String columnName) {
        ColumnHolder columnHolder = this.index.getColumnHolder(columnName);
        try (BaseColumn col = columnHolder.getColumn();){
            if (col instanceof ComplexColumn) {
                String string = ((ComplexColumn)col).getTypeName();
                return string;
            }
            String string = columnHolder.getCapabilities().getType().toString();
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public DateTime getMaxIngestedEventTime() {
        return this.getMaxTime();
    }

    @Override
    public Sequence<Cursor> makeCursors(@Nullable Filter filter, Interval interval, VirtualColumns virtualColumns, Granularity gran, boolean descending, @Nullable QueryMetrics<?> queryMetrics) {
        Offset offset;
        List<Filter> preFilters;
        DateTime minTime = this.getMinTime();
        long minDataTimestamp = minTime.getMillis();
        DateTime maxTime = this.getMaxTime();
        long maxDataTimestamp = maxTime.getMillis();
        Interval dataInterval = new Interval((ReadableInstant)minTime, (ReadableInstant)gran.bucketEnd(maxTime));
        if (!interval.overlaps((ReadableInterval)dataInterval)) {
            return Sequences.empty();
        }
        Interval actualInterval = interval.overlap((ReadableInterval)dataInterval);
        ColumnSelectorBitmapIndexSelector selector = new ColumnSelectorBitmapIndexSelector(this.index.getBitmapFactoryForDimensions(), virtualColumns, this.index);
        int totalRows = this.index.getNumRows();
        ArrayList<Filter> postFilters = new ArrayList<Filter>();
        int preFilteredRows = totalRows;
        if (filter == null) {
            preFilters = Collections.emptyList();
            offset = descending ? new SimpleDescendingOffset(totalRows) : new SimpleAscendingOffset(totalRows);
        } else {
            DefaultBitmapResultFactory bitmapResultFactory;
            preFilters = new ArrayList();
            if (filter instanceof AndFilter) {
                for (Filter subfilter : ((AndFilter)filter).getFilters()) {
                    if (subfilter.supportsBitmapIndex(selector)) {
                        preFilters.add(subfilter);
                        continue;
                    }
                    postFilters.add(subfilter);
                }
            } else if (filter.supportsBitmapIndex(selector)) {
                preFilters.add(filter);
            } else {
                postFilters.add(filter);
            }
            if (preFilters.size() == 0) {
                offset = descending ? new SimpleDescendingOffset(totalRows) : new SimpleAscendingOffset(totalRows);
            } else if (queryMetrics != null) {
                bitmapResultFactory = queryMetrics.makeBitmapResultFactory(selector.getBitmapFactory());
                long bitmapConstructionStartNs = System.nanoTime();
                ImmutableBitmap bitmapIndex = AndFilter.getBitmapIndex(selector, bitmapResultFactory, preFilters);
                preFilteredRows = bitmapIndex.size();
                offset = BitmapOffset.of(bitmapIndex, descending, totalRows);
                queryMetrics.reportBitmapConstructionTime(System.nanoTime() - bitmapConstructionStartNs);
            } else {
                bitmapResultFactory = new DefaultBitmapResultFactory(selector.getBitmapFactory());
                offset = BitmapOffset.of(AndFilter.getBitmapIndex(selector, bitmapResultFactory, preFilters), descending, totalRows);
            }
        }
        Filter postFilter = postFilters.size() == 0 ? null : (postFilters.size() == 1 ? (Filter)postFilters.get(0) : new AndFilter(postFilters));
        if (queryMetrics != null) {
            queryMetrics.preFilters(preFilters);
            queryMetrics.postFilters(postFilters);
            queryMetrics.reportSegmentRows(totalRows);
            queryMetrics.reportPreFilteredRows(preFilteredRows);
        }
        return Sequences.filter(new CursorSequenceBuilder(this, actualInterval, virtualColumns, gran, offset, minDataTimestamp, maxDataTimestamp, descending, postFilter, selector).build(), Objects::nonNull);
    }

    @Nullable
    static ColumnCapabilities getColumnCapabilities(ColumnSelector index, String columnName) {
        ColumnHolder columnHolder = index.getColumnHolder(columnName);
        if (columnHolder == null) {
            return null;
        }
        return columnHolder.getCapabilities();
    }

    @Override
    public Metadata getMetadata() {
        return this.index.getMetadata();
    }

    public static class DescendingTimestampCheckingOffset
    extends TimestampCheckingOffset {
        DescendingTimestampCheckingOffset(Offset baseOffset, NumericColumn timestamps, long timeLimit, boolean allWithinThreshold) {
            super(baseOffset, timestamps, timeLimit, allWithinThreshold);
        }

        @Override
        protected final boolean timeInRange(long current) {
            return current >= this.timeLimit;
        }

        public String toString() {
            return this.timeLimit + ">=" + (this.baseOffset.withinBounds() ? Long.valueOf(this.timestamps.getLongSingleValueRow(this.baseOffset.getOffset())) : "OOB") + "::" + this.baseOffset;
        }

        @Override
        public Offset clone() {
            return new DescendingTimestampCheckingOffset(this.baseOffset.clone(), this.timestamps, this.timeLimit, this.allWithinThreshold);
        }
    }

    public static class AscendingTimestampCheckingOffset
    extends TimestampCheckingOffset {
        AscendingTimestampCheckingOffset(Offset baseOffset, NumericColumn timestamps, long timeLimit, boolean allWithinThreshold) {
            super(baseOffset, timestamps, timeLimit, allWithinThreshold);
        }

        @Override
        protected final boolean timeInRange(long current) {
            return current < this.timeLimit;
        }

        public String toString() {
            return (this.baseOffset.withinBounds() ? Long.valueOf(this.timestamps.getLongSingleValueRow(this.baseOffset.getOffset())) : "OOB") + "<" + this.timeLimit + "::" + this.baseOffset;
        }

        @Override
        public Offset clone() {
            return new AscendingTimestampCheckingOffset(this.baseOffset.clone(), this.timestamps, this.timeLimit, this.allWithinThreshold);
        }
    }

    public static abstract class TimestampCheckingOffset
    extends Offset {
        final Offset baseOffset;
        final NumericColumn timestamps;
        final long timeLimit;
        final boolean allWithinThreshold;

        TimestampCheckingOffset(Offset baseOffset, NumericColumn timestamps, long timeLimit, boolean allWithinThreshold) {
            this.baseOffset = baseOffset;
            this.timestamps = timestamps;
            this.timeLimit = timeLimit;
            this.allWithinThreshold = allWithinThreshold;
        }

        @Override
        public int getOffset() {
            return this.baseOffset.getOffset();
        }

        @Override
        public boolean withinBounds() {
            if (!this.baseOffset.withinBounds()) {
                return false;
            }
            if (this.allWithinThreshold) {
                return true;
            }
            return this.timeInRange(this.timestamps.getLongSingleValueRow(this.baseOffset.getOffset()));
        }

        @Override
        public void reset() {
            this.baseOffset.reset();
        }

        @Override
        public ReadableOffset getBaseReadableOffset() {
            return this.baseOffset.getBaseReadableOffset();
        }

        protected abstract boolean timeInRange(long var1);

        @Override
        public void increment() {
            this.baseOffset.increment();
        }

        @Override
        public Offset clone() {
            throw new IllegalStateException("clone");
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("baseOffset", this.baseOffset);
            inspector.visit("timestamps", this.timestamps);
            inspector.visit("allWithinThreshold", this.allWithinThreshold);
        }
    }

    private static class QueryableIndexCursor
    implements HistoricalCursor {
        private final Offset cursorOffset;
        private final ColumnSelectorFactory columnSelectorFactory;
        private final DateTime bucketStart;

        QueryableIndexCursor(Offset cursorOffset, ColumnSelectorFactory columnSelectorFactory, DateTime bucketStart) {
            this.cursorOffset = cursorOffset;
            this.columnSelectorFactory = columnSelectorFactory;
            this.bucketStart = bucketStart;
        }

        @Override
        public Offset getOffset() {
            return this.cursorOffset;
        }

        @Override
        public ColumnSelectorFactory getColumnSelectorFactory() {
            return this.columnSelectorFactory;
        }

        @Override
        public DateTime getTime() {
            return this.bucketStart;
        }

        @Override
        public void advance() {
            this.cursorOffset.increment();
            BaseQuery.checkInterrupted();
        }

        @Override
        public void advanceUninterruptibly() {
            this.cursorOffset.increment();
        }

        @Override
        public void advanceTo(int offset) {
            for (int count = 0; count < offset && !this.isDone(); ++count) {
                this.advance();
            }
        }

        @Override
        public boolean isDone() {
            return !this.cursorOffset.withinBounds();
        }

        @Override
        public boolean isDoneOrInterrupted() {
            return this.isDone() || Thread.currentThread().isInterrupted();
        }

        @Override
        public void reset() {
            this.cursorOffset.reset();
        }
    }

    private static class CursorSequenceBuilder {
        private final QueryableIndex index;
        private final Interval interval;
        private final VirtualColumns virtualColumns;
        private final Granularity gran;
        private final Offset offset;
        private final long minDataTimestamp;
        private final long maxDataTimestamp;
        private final boolean descending;
        @Nullable
        private final Filter postFilter;
        private final ColumnSelectorBitmapIndexSelector bitmapIndexSelector;

        public CursorSequenceBuilder(QueryableIndexStorageAdapter storageAdapter, Interval interval, VirtualColumns virtualColumns, Granularity gran, Offset offset, long minDataTimestamp, long maxDataTimestamp, boolean descending, @Nullable Filter postFilter, ColumnSelectorBitmapIndexSelector bitmapIndexSelector) {
            this.index = storageAdapter.index;
            this.interval = interval;
            this.virtualColumns = virtualColumns;
            this.gran = gran;
            this.offset = offset;
            this.minDataTimestamp = minDataTimestamp;
            this.maxDataTimestamp = maxDataTimestamp;
            this.descending = descending;
            this.postFilter = postFilter;
            this.bitmapIndexSelector = bitmapIndexSelector;
        }

        public Sequence<Cursor> build() {
            final Offset baseOffset = this.offset.clone();
            final HashMap columnCache = new HashMap();
            final NumericColumn timestamps = (NumericColumn)this.index.getColumnHolder("__time").getColumn();
            final Closer closer = Closer.create();
            closer.register((Closeable)timestamps);
            Iterable iterable = this.gran.getIterable(this.interval);
            if (this.descending) {
                iterable = Lists.reverse((List)ImmutableList.copyOf((Iterable)iterable));
            }
            return Sequences.withBaggage((Sequence)Sequences.map((Sequence)Sequences.simple((Iterable)iterable), (Function)new Function<Interval, Cursor>(){

                public Cursor apply(Interval inputInterval) {
                    long timeStart = Math.max(interval.getStartMillis(), inputInterval.getStartMillis());
                    long timeEnd = Math.min(interval.getEndMillis(), gran.increment(inputInterval.getStart()).getMillis());
                    if (descending) {
                        while (baseOffset.withinBounds() && timestamps.getLongSingleValueRow(baseOffset.getOffset()) >= timeEnd) {
                            baseOffset.increment();
                        }
                    } else {
                        while (baseOffset.withinBounds() && timestamps.getLongSingleValueRow(baseOffset.getOffset()) < timeStart) {
                            baseOffset.increment();
                        }
                    }
                    TimestampCheckingOffset offset = descending ? new DescendingTimestampCheckingOffset(baseOffset, timestamps, timeStart, minDataTimestamp >= timeStart) : new AscendingTimestampCheckingOffset(baseOffset, timestamps, timeEnd, maxDataTimestamp < timeEnd);
                    Offset baseCursorOffset = ((Offset)offset).clone();
                    QueryableIndexColumnSelectorFactory columnSelectorFactory = new QueryableIndexColumnSelectorFactory(index, virtualColumns, descending, closer, baseCursorOffset.getBaseReadableOffset(), columnCache);
                    DateTime myBucket = gran.toDateTime(inputInterval.getStartMillis());
                    if (postFilter == null) {
                        return new QueryableIndexCursor(baseCursorOffset, columnSelectorFactory, myBucket);
                    }
                    FilteredOffset filteredOffset = new FilteredOffset(baseCursorOffset, columnSelectorFactory, descending, postFilter, bitmapIndexSelector);
                    return new QueryableIndexCursor(filteredOffset, columnSelectorFactory, myBucket);
                }
            }), (Closeable)closer);
        }
    }
}

