/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.io.Closeable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.LongColumnSelector;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.historical.HistoricalColumnSelector;

public interface ColumnarLongs
extends Closeable {
    public int size();

    public long get(int var1);

    public void fill(int var1, long[] var2);

    @Override
    public void close();

    default public ColumnValueSelector<Long> makeColumnValueSelector(final ReadableOffset offset, final ImmutableBitmap nullValueBitmap) {
        if (nullValueBitmap.isEmpty()) {
            class HistoricalLongColumnSelector
            implements LongColumnSelector,
            HistoricalColumnSelector<Long> {
                HistoricalLongColumnSelector() {
                }

                @Override
                public boolean isNull() {
                    return false;
                }

                @Override
                public long getLong() {
                    return ColumnarLongs.this.get(offset.getOffset());
                }

                @Override
                public double getDouble(int offset2) {
                    return ColumnarLongs.this.get(offset2);
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("columnar", ColumnarLongs.this);
                    inspector.visit("offset", offset);
                }
            }
            return new HistoricalLongColumnSelector();
        }
        class HistoricalLongColumnSelectorWithNulls
        implements LongColumnSelector,
        HistoricalColumnSelector<Long> {
            HistoricalLongColumnSelectorWithNulls() {
            }

            @Override
            public boolean isNull() {
                return nullValueBitmap.get(offset.getOffset());
            }

            @Override
            public long getLong() {
                assert (NullHandling.replaceWithDefault() || !this.isNull());
                return ColumnarLongs.this.get(offset.getOffset());
            }

            @Override
            public double getDouble(int offset2) {
                assert (NullHandling.replaceWithDefault() || !nullValueBitmap.get(offset2));
                return ColumnarLongs.this.get(offset2);
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("columnar", ColumnarLongs.this);
                inspector.visit("offset", offset);
                inspector.visit("nullValueBitmap", nullValueBitmap);
            }
        }
        return new HistoricalLongColumnSelectorWithNulls();
    }
}

