/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import org.apache.druid.common.utils.ByteUtils;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.data.CompressedVSizeColumnarIntsSupplier;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.GenericIndexedWriter;
import org.apache.druid.segment.data.SingleValueColumnarIntsSerializer;
import org.apache.druid.segment.data.VSizeColumnarInts;
import org.apache.druid.segment.serde.MetaSerdeHelper;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class CompressedVSizeColumnarIntsSerializer
extends SingleValueColumnarIntsSerializer {
    private static final byte VERSION = 2;
    private static final MetaSerdeHelper<CompressedVSizeColumnarIntsSerializer> metaSerdeHelper = MetaSerdeHelper.firstWriteByte(x -> 2).writeByte(x -> ByteUtils.checkedCast((int)x.numBytes)).writeInt(x -> x.numInserted).writeInt(x -> x.chunkFactor).writeByte(x -> x.compression.getId());
    private final int numBytes;
    private final int chunkFactor;
    private final boolean isBigEndian;
    private final CompressionStrategy compression;
    private final GenericIndexedWriter<ByteBuffer> flattener;
    private final ByteBuffer intBuffer;
    private ByteBuffer endBuffer;
    private int numInserted;

    public static CompressedVSizeColumnarIntsSerializer create(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, int maxValue, CompressionStrategy compression) {
        return new CompressedVSizeColumnarIntsSerializer(segmentWriteOutMedium, filenameBase, maxValue, CompressedVSizeColumnarIntsSupplier.maxIntsInBufferForValue(maxValue), IndexIO.BYTE_ORDER, compression);
    }

    CompressedVSizeColumnarIntsSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, int maxValue, int chunkFactor, ByteOrder byteOrder, CompressionStrategy compression) {
        this(segmentWriteOutMedium, maxValue, chunkFactor, byteOrder, compression, GenericIndexedWriter.ofCompressedByteBuffers(segmentWriteOutMedium, filenameBase, compression, CompressedVSizeColumnarIntsSerializer.sizePer(maxValue, chunkFactor)));
    }

    CompressedVSizeColumnarIntsSerializer(SegmentWriteOutMedium segmentWriteOutMedium, int maxValue, int chunkFactor, ByteOrder byteOrder, CompressionStrategy compression, GenericIndexedWriter<ByteBuffer> flattener) {
        this.numBytes = VSizeColumnarInts.getNumBytesForMax(maxValue);
        this.chunkFactor = chunkFactor;
        int chunkBytes = chunkFactor * this.numBytes;
        this.isBigEndian = byteOrder.equals(ByteOrder.BIG_ENDIAN);
        this.compression = compression;
        this.flattener = flattener;
        this.intBuffer = ByteBuffer.allocate(4).order(byteOrder);
        CompressionStrategy.Compressor compressor = compression.getCompressor();
        this.endBuffer = compressor.allocateInBuffer(chunkBytes, segmentWriteOutMedium.getCloser()).order(byteOrder);
        this.numInserted = 0;
    }

    private static int sizePer(int maxValue, int chunkFactor) {
        return chunkFactor * VSizeColumnarInts.getNumBytesForMax(maxValue) + CompressedVSizeColumnarIntsSupplier.bufferPadding(VSizeColumnarInts.getNumBytesForMax(maxValue));
    }

    @Override
    public void open() throws IOException {
        this.flattener.open();
    }

    @Override
    public void addValue(int val) throws IOException {
        if (this.endBuffer == null) {
            throw new IllegalStateException("written out already");
        }
        if (!this.endBuffer.hasRemaining()) {
            this.endBuffer.rewind();
            this.flattener.write(this.endBuffer);
            this.endBuffer.clear();
        }
        this.intBuffer.putInt(0, val);
        if (this.isBigEndian) {
            this.endBuffer.put(this.intBuffer.array(), 4 - this.numBytes, this.numBytes);
        } else {
            this.endBuffer.put(this.intBuffer.array(), 0, this.numBytes);
        }
        ++this.numInserted;
    }

    @Override
    public long getSerializedSize() throws IOException {
        this.writeEndBuffer();
        return (long)metaSerdeHelper.size(this) + this.flattener.getSerializedSize();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.writeEndBuffer();
        metaSerdeHelper.writeTo(channel, this);
        this.flattener.writeTo(channel, smoosher);
    }

    private void writeEndBuffer() throws IOException {
        if (this.endBuffer != null) {
            this.endBuffer.flip();
            if (this.endBuffer.remaining() > 0) {
                this.flattener.write(this.endBuffer);
            }
            this.endBuffer = null;
        }
    }
}

