/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import javax.annotation.Nullable;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionIndexer;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.SingleScanTimeDimensionSelector;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexRowHolder;

class IncrementalIndexColumnSelectorFactory
implements ColumnSelectorFactory {
    private final IncrementalIndex<?> index;
    private final VirtualColumns virtualColumns;
    private final boolean descending;
    private final IncrementalIndexRowHolder rowHolder;

    IncrementalIndexColumnSelectorFactory(IncrementalIndex<?> index, VirtualColumns virtualColumns, boolean descending, IncrementalIndexRowHolder rowHolder) {
        this.index = index;
        this.virtualColumns = virtualColumns;
        this.descending = descending;
        this.rowHolder = rowHolder;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
        if (this.virtualColumns.exists(dimensionSpec.getDimension())) {
            return this.virtualColumns.makeDimensionSelector(dimensionSpec, this);
        }
        return dimensionSpec.decorate(this.makeDimensionSelectorUndecorated(dimensionSpec));
    }

    private DimensionSelector makeDimensionSelectorUndecorated(DimensionSpec dimensionSpec) {
        String dimension = dimensionSpec.getDimension();
        ExtractionFn extractionFn = dimensionSpec.getExtractionFn();
        if (dimension.equals("__time")) {
            return new SingleScanTimeDimensionSelector(this.makeColumnValueSelector(dimension), extractionFn, this.descending);
        }
        IncrementalIndex.DimensionDesc dimensionDesc = this.index.getDimension(dimensionSpec.getDimension());
        if (dimensionDesc == null) {
            ColumnCapabilities capabilities = this.getColumnCapabilities(dimension);
            if (capabilities == null) {
                return DimensionSelector.constant(null, extractionFn);
            }
            if (capabilities.getType().isNumeric()) {
                return capabilities.getType().makeNumericWrappingDimensionSelector(this.makeColumnValueSelector(dimension), extractionFn);
            }
            return DimensionSelector.constant(null, extractionFn);
        }
        DimensionIndexer indexer = dimensionDesc.getIndexer();
        return indexer.makeDimensionSelector(dimensionSpec, this.rowHolder, dimensionDesc);
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.makeColumnValueSelector(columnName, this);
        }
        if (columnName.equals("__time")) {
            return this.rowHolder;
        }
        Integer dimIndex = this.index.getDimensionIndex(columnName);
        if (dimIndex != null) {
            IncrementalIndex.DimensionDesc dimensionDesc = this.index.getDimension(columnName);
            DimensionIndexer indexer = dimensionDesc.getIndexer();
            return indexer.makeColumnValueSelector(this.rowHolder, dimensionDesc);
        }
        return this.index.makeMetricColumnValueSelector(columnName, this.rowHolder);
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.getColumnCapabilities(columnName);
        }
        return this.index.getCapabilities(columnName);
    }
}

