/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import java.util.Iterator;
import java.util.function.BiFunction;
import org.apache.druid.query.Query;
import org.apache.druid.query.aggregation.AggregatorFactory;

public interface CacheStrategy<T, CacheType, QueryType extends Query<T>> {
    public boolean isCacheable(QueryType var1, boolean var2);

    public byte[] computeCacheKey(QueryType var1);

    public byte[] computeResultLevelCacheKey(QueryType var1);

    public TypeReference<CacheType> getCacheObjectClazz();

    public Function<T, CacheType> prepareForCache(boolean var1);

    public Function<CacheType, T> pullFromCache(boolean var1);

    default public Function<T, CacheType> prepareForSegmentLevelCache() {
        return this.prepareForCache(false);
    }

    default public Function<CacheType, T> pullFromSegmentLevelCache() {
        return this.pullFromCache(false);
    }

    public static void fetchAggregatorsFromCache(Iterator<AggregatorFactory> aggIter, Iterator<Object> resultIter, boolean isResultLevelCache, BiFunction<String, Object, Void> addToResultFunction) {
        while (aggIter.hasNext() && resultIter.hasNext()) {
            AggregatorFactory factory = aggIter.next();
            if (isResultLevelCache) {
                addToResultFunction.apply(factory.getName(), resultIter.next());
                continue;
            }
            addToResultFunction.apply(factory.getName(), factory.deserialize(resultIter.next()));
        }
    }
}

