/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.collect.Ordering;
import com.google.common.primitives.Doubles;
import java.util.Comparator;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;

public class DoubleSumAggregator
implements Aggregator {
    static final Comparator COMPARATOR = new Ordering(){

        public int compare(Object o, Object o1) {
            return Doubles.compare((double)((Number)o).doubleValue(), (double)((Number)o1).doubleValue());
        }
    }.nullsFirst();
    private final BaseDoubleColumnValueSelector selector;
    private double sum;

    static double combineValues(Object lhs, Object rhs) {
        return ((Number)lhs).doubleValue() + ((Number)rhs).doubleValue();
    }

    public DoubleSumAggregator(BaseDoubleColumnValueSelector selector) {
        this.selector = selector;
        this.sum = 0.0;
    }

    @Override
    public void aggregate() {
        this.sum += this.selector.getDouble();
    }

    @Override
    public Object get() {
        return this.sum;
    }

    @Override
    public float getFloat() {
        return (float)this.sum;
    }

    @Override
    public long getLong() {
        return (long)this.sum;
    }

    @Override
    public void close() {
    }

    @Override
    public double getDouble() {
        return this.sum;
    }
}

