/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.DoubleMaxAggregateCombiner;
import org.apache.druid.query.aggregation.FloatMaxAggregator;
import org.apache.druid.query.aggregation.FloatMaxBufferAggregator;
import org.apache.druid.query.aggregation.SimpleFloatAggregatorFactory;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;

public class FloatMaxAggregatorFactory
extends SimpleFloatAggregatorFactory {
    @JsonCreator
    public FloatMaxAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="expression") String expression, @JacksonInject ExprMacroTable macroTable) {
        super(macroTable, name, fieldName, expression);
    }

    public FloatMaxAggregatorFactory(String name, String fieldName) {
        this(name, fieldName, null, ExprMacroTable.nil());
    }

    @Override
    protected BaseFloatColumnValueSelector selector(ColumnSelectorFactory metricFactory) {
        return this.getFloatColumnSelector(metricFactory, Float.NEGATIVE_INFINITY);
    }

    @Override
    protected Aggregator factorize(ColumnSelectorFactory metricFactory, BaseFloatColumnValueSelector selector) {
        return new FloatMaxAggregator(selector);
    }

    @Override
    protected BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory, BaseFloatColumnValueSelector selector) {
        return new FloatMaxBufferAggregator(selector);
    }

    @Override
    @Nullable
    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        if (rhs == null) {
            return lhs;
        }
        if (lhs == null) {
            return rhs;
        }
        return FloatMaxAggregator.combineValues(lhs, rhs);
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        return new DoubleMaxAggregateCombiner();
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new FloatMaxAggregatorFactory(this.name, this.name, null, this.macroTable);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new FloatMaxAggregatorFactory(this.fieldName, this.fieldName, this.expression, this.macroTable));
    }

    public byte[] getCacheKey() {
        byte[] fieldNameBytes = StringUtils.toUtf8WithNullToEmpty((String)this.fieldName);
        byte[] expressionBytes = StringUtils.toUtf8WithNullToEmpty((String)this.expression);
        return ByteBuffer.allocate(2 + fieldNameBytes.length + expressionBytes.length).put((byte)13).put(fieldNameBytes).put((byte)-1).put(expressionBytes).array();
    }

    public String toString() {
        return "FloatMaxAggregatorFactory{fieldName='" + this.fieldName + '\'' + ", expression='" + this.expression + '\'' + ", name='" + this.name + '\'' + '}';
    }
}

