/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.druid.data.input.Row;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryQueryToolChest;
import org.apache.druid.query.groupby.strategy.GroupByStrategySelector;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.StorageAdapter;

public class GroupByQueryRunnerFactory
implements QueryRunnerFactory<Row, GroupByQuery> {
    private final GroupByStrategySelector strategySelector;
    private final GroupByQueryQueryToolChest toolChest;

    @Inject
    public GroupByQueryRunnerFactory(GroupByStrategySelector strategySelector, GroupByQueryQueryToolChest toolChest) {
        this.strategySelector = strategySelector;
        this.toolChest = toolChest;
    }

    @Override
    public QueryRunner<Row> createRunner(Segment segment) {
        return new GroupByQueryRunner(segment, this.strategySelector);
    }

    @Override
    public QueryRunner<Row> mergeRunners(ExecutorService exec, final Iterable<QueryRunner<Row>> queryRunners) {
        final ListeningExecutorService queryExecutor = MoreExecutors.listeningDecorator((ExecutorService)exec);
        return new QueryRunner<Row>(){

            @Override
            public Sequence<Row> run(QueryPlus<Row> queryPlus, Map<String, Object> responseContext) {
                QueryRunner<Row> rowQueryRunner = GroupByQueryRunnerFactory.this.strategySelector.strategize((GroupByQuery)queryPlus.getQuery()).mergeRunners(queryExecutor, queryRunners);
                return rowQueryRunner.run(queryPlus, responseContext);
            }
        };
    }

    @Override
    public QueryToolChest<Row, GroupByQuery> getToolchest() {
        return this.toolChest;
    }

    @VisibleForTesting
    public GroupByStrategySelector getStrategySelector() {
        return this.strategySelector;
    }

    private static class GroupByQueryRunner
    implements QueryRunner<Row> {
        private final StorageAdapter adapter;
        private final GroupByStrategySelector strategySelector;

        public GroupByQueryRunner(Segment segment, GroupByStrategySelector strategySelector) {
            this.adapter = segment.asStorageAdapter();
            this.strategySelector = strategySelector;
        }

        @Override
        public Sequence<Row> run(QueryPlus<Row> queryPlus, Map<String, Object> responseContext) {
            Query<Row> query = queryPlus.getQuery();
            if (!(query instanceof GroupByQuery)) {
                throw new ISE("Got a [%s] which isn't a %s", new Object[]{query.getClass(), GroupByQuery.class});
            }
            return this.strategySelector.strategize((GroupByQuery)query).process((GroupByQuery)query, this.adapter);
        }
    }
}

