/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn.types;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.topn.BaseTopNAlgorithm;
import org.apache.druid.query.topn.TopNParams;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNResultBuilder;
import org.apache.druid.query.topn.types.TopNColumnSelectorStrategy;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.IndexedInts;

public class StringTopNColumnSelectorStrategy
implements TopNColumnSelectorStrategy<DimensionSelector, Map<Comparable<?>, Aggregator[]>> {
    private final Function<Object, Comparable<?>> dimensionValueConverter;

    public StringTopNColumnSelectorStrategy(ValueType dimensionType) {
        this.dimensionValueConverter = DimensionHandlerUtils.converterFromTypeToType(ValueType.STRING, dimensionType);
    }

    @Override
    public int getCardinality(DimensionSelector selector) {
        return selector.getValueCardinality();
    }

    @Override
    public Aggregator[][] getDimExtractionRowSelector(TopNQuery query, TopNParams params, StorageAdapter storageAdapter) {
        if (params.getCardinality() < 0) {
            throw new UnsupportedOperationException("Cannot operate on a dimension with unknown cardinality");
        }
        BaseTopNAlgorithm.AggregatorArrayProvider provider = new BaseTopNAlgorithm.AggregatorArrayProvider((DimensionSelector)params.getSelectorPlus().getSelector(), query, params.getCardinality(), storageAdapter);
        return provider.build();
    }

    @Override
    public Map<Comparable<?>, Aggregator[]> makeDimExtractionAggregateStore() {
        return new HashMap();
    }

    @Override
    public long dimExtractionScanAndAggregate(TopNQuery query, DimensionSelector selector, Cursor cursor, Aggregator[][] rowSelector, Map<Comparable<?>, Aggregator[]> aggregatesStore) {
        if (selector.getValueCardinality() != -1) {
            return this.dimExtractionScanAndAggregateWithCardinalityKnown(query, cursor, selector, rowSelector, aggregatesStore);
        }
        return this.dimExtractionScanAndAggregateWithCardinalityUnknown(query, cursor, selector, aggregatesStore);
    }

    @Override
    public void updateDimExtractionResults(Map<Comparable<?>, Aggregator[]> aggregatesStore, TopNResultBuilder resultBuilder) {
        for (Map.Entry<Comparable<?>, Aggregator[]> entry : aggregatesStore.entrySet()) {
            Aggregator[] aggs = entry.getValue();
            if (aggs == null) continue;
            Object[] vals = new Object[aggs.length];
            for (int i = 0; i < aggs.length; ++i) {
                vals[i] = aggs[i].get();
            }
            Comparable<?> key = this.dimensionValueConverter.apply(entry.getKey());
            resultBuilder.addEntry(key, key, vals);
        }
    }

    private long dimExtractionScanAndAggregateWithCardinalityKnown(TopNQuery query, Cursor cursor, DimensionSelector selector, Aggregator[][] rowSelector, Map<Comparable<?>, Aggregator[]> aggregatesStore) {
        long processedRows = 0L;
        while (!cursor.isDone()) {
            IndexedInts dimValues = selector.getRow();
            int size = dimValues.size();
            for (int i = 0; i < size; ++i) {
                int dimIndex = dimValues.get(i);
                Aggregator[] theAggregators = rowSelector[dimIndex];
                if (theAggregators == null) {
                    Comparable<?> key = this.dimensionValueConverter.apply(selector.lookupName(dimIndex));
                    theAggregators = aggregatesStore.get(key);
                    if (theAggregators == null) {
                        theAggregators = BaseTopNAlgorithm.makeAggregators(cursor, query.getAggregatorSpecs());
                        aggregatesStore.put(key, theAggregators);
                    }
                    rowSelector[dimIndex] = theAggregators;
                }
                for (Aggregator aggregator : theAggregators) {
                    aggregator.aggregate();
                }
            }
            cursor.advance();
            ++processedRows;
        }
        return processedRows;
    }

    private long dimExtractionScanAndAggregateWithCardinalityUnknown(TopNQuery query, Cursor cursor, DimensionSelector selector, Map<Comparable<?>, Aggregator[]> aggregatesStore) {
        long processedRows = 0L;
        while (!cursor.isDone()) {
            IndexedInts dimValues = selector.getRow();
            int size = dimValues.size();
            for (int i = 0; i < size; ++i) {
                int dimIndex = dimValues.get(i);
                Comparable<?> key = this.dimensionValueConverter.apply(selector.lookupName(dimIndex));
                Aggregator[] theAggregators = aggregatesStore.get(key);
                if (theAggregators == null) {
                    theAggregators = BaseTopNAlgorithm.makeAggregators(cursor, query.getAggregatorSpecs());
                    aggregatesStore.put(key, theAggregators);
                }
                for (Aggregator aggregator : theAggregators) {
                    aggregator.aggregate();
                }
            }
            cursor.advance();
            ++processedRows;
        }
        return processedRows;
    }
}

