/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import javax.annotation.Nullable;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.ObjectColumnSelector;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.ReadableOffset;

public class ComplexColumn
implements BaseColumn {
    private final GenericIndexed<?> index;
    private final String typeName;

    public ComplexColumn(String typeName, GenericIndexed<?> index) {
        this.index = index;
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    @Nullable
    public Object getRowValue(int rowNum) {
        return this.index.get(rowNum);
    }

    public int getLength() {
        return this.index.size();
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(final ReadableOffset offset) {
        return new ObjectColumnSelector(){

            @Override
            @Nullable
            public Object getObject() {
                return ComplexColumn.this.getRowValue(offset.getOffset());
            }

            @Override
            public Class classOfObject() {
                return ComplexColumn.this.index.getClazz();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("column", ComplexColumn.this);
            }
        };
    }

    @Override
    public void close() {
    }
}

