/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections.bitmap;

import java.nio.ByteBuffer;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public class WrappedImmutableRoaringBitmap
implements ImmutableBitmap {
    private final ImmutableRoaringBitmap bitmap;

    protected WrappedImmutableRoaringBitmap(ByteBuffer byteBuffer) {
        this.bitmap = new ImmutableRoaringBitmap(byteBuffer);
    }

    public WrappedImmutableRoaringBitmap(ImmutableRoaringBitmap immutableRoaringBitmap) {
        this.bitmap = immutableRoaringBitmap;
    }

    public ImmutableRoaringBitmap getBitmap() {
        return this.bitmap;
    }

    @Override
    public byte[] toBytes() {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(this.bitmap.serializedSizeInBytes());
            this.bitmap.serialize(buffer);
            return buffer.array();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.bitmap;
    }

    @Override
    public IntIterator iterator() {
        return this.bitmap.getIntIterator();
    }

    @Override
    public int size() {
        return this.bitmap.getCardinality();
    }

    @Override
    public boolean isEmpty() {
        return this.bitmap.isEmpty();
    }

    @Override
    public boolean get(int value) {
        return this.bitmap.contains(value);
    }

    @Override
    public ImmutableBitmap intersection(ImmutableBitmap otherBitmap) {
        WrappedImmutableRoaringBitmap other = (WrappedImmutableRoaringBitmap)otherBitmap;
        ImmutableRoaringBitmap unwrappedOtherBitmap = other.bitmap;
        return new WrappedImmutableRoaringBitmap((ImmutableRoaringBitmap)ImmutableRoaringBitmap.and((ImmutableRoaringBitmap)this.bitmap, (ImmutableRoaringBitmap)unwrappedOtherBitmap));
    }
}

