/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import java.util.ArrayList;
import java.util.Map;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.Result;
import org.apache.druid.query.SegmentDescriptor;

public class ReportTimelineMissingSegmentQueryRunner<T>
implements QueryRunner<T> {
    private final SegmentDescriptor descriptor;

    public ReportTimelineMissingSegmentQueryRunner(SegmentDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, Map<String, Object> responseContext) {
        ArrayList<SegmentDescriptor> missingSegments = (ArrayList<SegmentDescriptor>)responseContext.get(Result.MISSING_SEGMENTS_KEY);
        if (missingSegments == null) {
            missingSegments = new ArrayList<SegmentDescriptor>();
            responseContext.put(Result.MISSING_SEGMENTS_KEY, missingSegments);
        }
        missingSegments.add(this.descriptor);
        return Sequences.empty();
    }
}

