/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.google.common.base.Predicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.ValueGetter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.ValueMatcherColumnSelectorStrategy;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.filter.BooleanValueMatcher;

public class StringValueMatcherColumnSelectorStrategy
implements ValueMatcherColumnSelectorStrategy<DimensionSelector> {
    private static final String[] NULL_VALUE = new String[]{null};
    private static final ValueGetter NULL_VALUE_GETTER = () -> NULL_VALUE;

    @Override
    public ValueMatcher makeValueMatcher(DimensionSelector selector, String value) {
        if (selector.getValueCardinality() == 0) {
            return BooleanValueMatcher.of(value == null);
        }
        return selector.makeValueMatcher(value);
    }

    @Override
    public ValueMatcher makeValueMatcher(DimensionSelector selector, DruidPredicateFactory predicateFactory) {
        Predicate<String> predicate = predicateFactory.makeStringPredicate();
        if (selector.getValueCardinality() == 0) {
            return BooleanValueMatcher.of(predicate.apply(null));
        }
        return selector.makeValueMatcher(predicate);
    }

    @Override
    public ValueGetter makeValueGetter(DimensionSelector selector) {
        if (selector.getValueCardinality() == 0) {
            return NULL_VALUE_GETTER;
        }
        return () -> {
            IndexedInts row = selector.getRow();
            int size = row.size();
            if (size == 0) {
                return NULL_VALUE;
            }
            String[] values = new String[size];
            for (int i = 0; i < size; ++i) {
                values[i] = selector.lookupName(row.get(i));
            }
            return values;
        };
    }
}

