/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.having;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.groupby.having.BaseHavingSpec;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.transform.RowFunction;
import org.apache.druid.segment.transform.Transform;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.segment.transform.Transformer;
import org.joda.time.DateTime;

public class DimFilterHavingSpec
extends BaseHavingSpec {
    private static final boolean DEFAULT_FINALIZE = true;
    private final DimFilter dimFilter;
    private final boolean finalize;
    private Map<String, ValueType> rowSignature = new HashMap<String, ValueType>();
    private Map<String, AggregatorFactory> aggregators = new HashMap<String, AggregatorFactory>();
    private Transformer transformer = null;
    private int evalCount;

    @JsonCreator
    public DimFilterHavingSpec(@JsonProperty(value="filter") DimFilter dimFilter, @JsonProperty(value="finalize") Boolean finalize) {
        this.dimFilter = (DimFilter)Preconditions.checkNotNull((Object)dimFilter, (Object)"filter");
        this.finalize = finalize == null ? true : finalize;
    }

    @JsonProperty(value="filter")
    public DimFilter getDimFilter() {
        return this.dimFilter;
    }

    @JsonProperty
    public boolean isFinalize() {
        return this.finalize;
    }

    @Override
    public void setRowSignature(Map<String, ValueType> rowSignature) {
        this.rowSignature = rowSignature;
    }

    @Override
    public void setAggregators(Map<String, AggregatorFactory> aggregators) {
        this.aggregators = aggregators;
    }

    @Override
    public boolean eval(Row row) {
        boolean retVal;
        int oldEvalCount = this.evalCount++;
        if (this.transformer == null) {
            this.transformer = DimFilterHavingSpec.createTransformer(this.dimFilter, this.rowSignature, this.aggregators, this.finalize);
        }
        boolean bl = retVal = this.transformer.transform(new RowAsInputRow(row)) != null;
        if (this.evalCount != oldEvalCount + 1) {
            throw new IllegalStateException("concurrent 'eval' calls not permitted!");
        }
        return retVal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimFilterHavingSpec that = (DimFilterHavingSpec)o;
        return this.finalize == that.finalize && Objects.equals(this.dimFilter, that.dimFilter);
    }

    public int hashCode() {
        return Objects.hash(this.dimFilter, this.finalize);
    }

    public String toString() {
        return "DimFilterHavingSpec{dimFilter=" + this.dimFilter + ", finalize=" + this.finalize + '}';
    }

    private static Transformer createTransformer(DimFilter filter, Map<String, ValueType> rowSignature, Map<String, AggregatorFactory> aggregators, boolean finalize) {
        ArrayList<Transform> transforms = new ArrayList<Transform>();
        if (finalize) {
            for (final AggregatorFactory aggregator : aggregators.values()) {
                final String name = aggregator.getName();
                transforms.add(new Transform(){

                    @Override
                    public String getName() {
                        return name;
                    }

                    @Override
                    public RowFunction getRowFunction() {
                        return row -> aggregator.finalizeComputation(row.getRaw(name));
                    }
                });
            }
        }
        return new TransformSpec(filter, transforms).toTransformer(rowSignature);
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(3).appendCacheable(this.dimFilter).appendByte((byte)(this.isFinalize() ? 1 : 0)).build();
    }

    private static class RowAsInputRow
    implements InputRow {
        private final Row row;

        public RowAsInputRow(Row row) {
            this.row = row;
        }

        public List<String> getDimensions() {
            return Collections.emptyList();
        }

        public long getTimestampFromEpoch() {
            return this.row.getTimestampFromEpoch();
        }

        public DateTime getTimestamp() {
            return this.row.getTimestamp();
        }

        public List<String> getDimension(String dimension) {
            return this.row.getDimension(dimension);
        }

        public Object getRaw(String dimension) {
            return this.row.getRaw(dimension);
        }

        public Number getMetric(String metric) {
            return this.row.getMetric(metric);
        }

        public int compareTo(Row o) {
            return this.row.compareTo((Object)o);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RowAsInputRow that = (RowAsInputRow)o;
            return Objects.equals(this.row, that.row);
        }

        public int hashCode() {
            return Objects.hash(this.row);
        }

        public String toString() {
            return "RowAsInputRow{row=" + this.row + '}';
        }
    }
}

