/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.select;

import com.google.common.annotations.VisibleForTesting;

public abstract class PagingOffset {
    protected final int startOffset;
    protected final int threshold;
    protected int counter;

    public PagingOffset(int startOffset, int threshold) {
        this.startOffset = startOffset;
        this.threshold = threshold;
    }

    public final int startOffset() {
        return this.startOffset;
    }

    public abstract int startDelta();

    public final int threshold() {
        return this.threshold;
    }

    public final boolean hasNext() {
        return this.counter < this.threshold;
    }

    public final void next() {
        ++this.counter;
    }

    public abstract int current();

    public static PagingOffset of(int startOffset, int threshold) {
        return startOffset < 0 ? new Descending(startOffset, threshold) : new Ascending(startOffset, threshold);
    }

    @VisibleForTesting
    static int toOffset(int delta, boolean descending) {
        if (delta < 0) {
            throw new IllegalArgumentException("Delta should not be negative");
        }
        return descending ? -delta - 1 : delta;
    }

    private static class Descending
    extends PagingOffset {
        public Descending(int offset, int threshold) {
            super(offset, threshold);
        }

        @Override
        public final int startDelta() {
            return -this.startOffset - 1;
        }

        @Override
        public final int current() {
            return this.startOffset - this.counter;
        }
    }

    private static class Ascending
    extends PagingOffset {
        public Ascending(int offset, int threshold) {
            super(offset, threshold);
        }

        @Override
        public final int startDelta() {
            return this.startOffset;
        }

        @Override
        public final int current() {
            return this.startOffset + this.counter;
        }
    }
}

