/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Predicate;
import java.util.regex.Pattern;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.segment.filter.DimensionPredicateFilter;

public class RegexFilter
extends DimensionPredicateFilter {
    public RegexFilter(String dimension, final Pattern pattern, ExtractionFn extractionFn) {
        super(dimension, new DruidPredicateFactory(){

            @Override
            public Predicate<String> makeStringPredicate() {
                return input -> input != null && pattern.matcher((CharSequence)input).find();
            }

            @Override
            public DruidLongPredicate makeLongPredicate() {
                return input -> pattern.matcher(String.valueOf(input)).find();
            }

            @Override
            public DruidFloatPredicate makeFloatPredicate() {
                return input -> pattern.matcher(String.valueOf(input)).find();
            }

            @Override
            public DruidDoublePredicate makeDoublePredicate() {
                return input -> pattern.matcher(String.valueOf(input)).find();
            }

            public String toString() {
                return "RegexFilter{pattern='" + pattern + '\'' + '}';
            }
        }, extractionFn);
    }
}

