/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.google.common.base.Function;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.serde.ComplexColumnSerializer;
import org.apache.druid.segment.serde.ComplexMetricExtractor;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public abstract class ComplexMetricSerde {
    public abstract String getTypeName();

    public abstract ComplexMetricExtractor getExtractor();

    public abstract void deserializeColumn(ByteBuffer var1, ColumnBuilder var2);

    @Deprecated
    public abstract ObjectStrategy getObjectStrategy();

    public Function<Object, Long> inputSizeFn() {
        return null;
    }

    public byte[] toBytes(@Nullable Object val) {
        if (val != null) {
            byte[] bytes = this.getObjectStrategy().toBytes(val);
            return bytes != null ? bytes : ByteArrays.EMPTY_ARRAY;
        }
        return ByteArrays.EMPTY_ARRAY;
    }

    public Object fromBytes(byte[] data, int start, int numBytes) {
        ByteBuffer bb = ByteBuffer.wrap(data);
        if (start > 0) {
            bb.position(start);
        }
        return this.getObjectStrategy().fromByteBuffer(bb, numBytes);
    }

    public GenericColumnSerializer getSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String column) {
        return ComplexColumnSerializer.create(segmentWriteOutMedium, column, this.getObjectStrategy());
    }
}

