/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.query.DefaultQueryMetrics;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryMetrics;

@LazySingleton
public class DefaultGenericQueryMetricsFactory
implements GenericQueryMetricsFactory {
    private static final GenericQueryMetricsFactory INSTANCE = new DefaultGenericQueryMetricsFactory(new DefaultObjectMapper());
    private final ObjectMapper jsonMapper;

    @VisibleForTesting
    public static GenericQueryMetricsFactory instance() {
        return INSTANCE;
    }

    @Inject
    public DefaultGenericQueryMetricsFactory(@Json ObjectMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    @Override
    public QueryMetrics<Query<?>> makeMetrics(Query<?> query) {
        DefaultQueryMetrics queryMetrics = new DefaultQueryMetrics(this.jsonMapper);
        queryMetrics.query(query);
        return queryMetrics;
    }
}

