/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.ObjLongConsumer;
import org.apache.druid.java.util.common.guava.LazySequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.SequenceWrapper;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryToolChest;

public class MetricsEmittingQueryRunner<T>
implements QueryRunner<T> {
    private final ServiceEmitter emitter;
    private final QueryToolChest<T, ? extends Query<T>> queryToolChest;
    private final QueryRunner<T> queryRunner;
    private final long creationTimeNs;
    private final ObjLongConsumer<? super QueryMetrics<?>> reportMetric;
    private final Consumer<QueryMetrics<?>> applyCustomDimensions;
    private static final Logger log = new Logger(MetricsEmittingQueryRunner.class);

    private MetricsEmittingQueryRunner(ServiceEmitter emitter, QueryToolChest<T, ? extends Query<T>> queryToolChest, QueryRunner<T> queryRunner, long creationTimeNs, ObjLongConsumer<? super QueryMetrics<?>> reportMetric, Consumer<QueryMetrics<?>> applyCustomDimensions) {
        this.emitter = emitter;
        this.queryToolChest = queryToolChest;
        this.queryRunner = queryRunner;
        this.creationTimeNs = creationTimeNs;
        this.reportMetric = reportMetric;
        this.applyCustomDimensions = applyCustomDimensions;
    }

    public MetricsEmittingQueryRunner(ServiceEmitter emitter, QueryToolChest<T, ? extends Query<T>> queryToolChest, QueryRunner<T> queryRunner, ObjLongConsumer<? super QueryMetrics<?>> reportMetric, Consumer<QueryMetrics<?>> applyCustomDimensions) {
        this(emitter, queryToolChest, queryRunner, -1L, reportMetric, applyCustomDimensions);
    }

    public MetricsEmittingQueryRunner<T> withWaitMeasuredFromNow() {
        return new MetricsEmittingQueryRunner<T>(this.emitter, this.queryToolChest, this.queryRunner, System.nanoTime(), this.reportMetric, this.applyCustomDimensions);
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, Map<String, Object> responseContext) {
        QueryPlus<T> queryWithMetrics = queryPlus.withQueryMetrics(this.queryToolChest);
        final QueryMetrics<?> queryMetrics = queryWithMetrics.getQueryMetrics();
        this.applyCustomDimensions.accept(queryMetrics);
        return Sequences.wrap((Sequence)new LazySequence(() -> this.queryRunner.run(queryWithMetrics, responseContext)), (SequenceWrapper)new SequenceWrapper(){
            private long startTimeNs;

            public void before() {
                this.startTimeNs = System.nanoTime();
            }

            public void after(boolean isDone, Throwable thrown) {
                if (thrown != null) {
                    queryMetrics.status("failed");
                } else if (!isDone) {
                    queryMetrics.status("short");
                }
                long timeTakenNs = System.nanoTime() - this.startTimeNs;
                MetricsEmittingQueryRunner.this.reportMetric.accept(queryMetrics, timeTakenNs);
                if (MetricsEmittingQueryRunner.this.creationTimeNs > 0L) {
                    queryMetrics.reportWaitTime(this.startTimeNs - MetricsEmittingQueryRunner.this.creationTimeNs);
                }
                try {
                    queryMetrics.emit(MetricsEmittingQueryRunner.this.emitter);
                }
                catch (Exception e) {
                    log.error("Failure while trying to emit [%s] with stacktrace [%s]", new Object[]{MetricsEmittingQueryRunner.this.emitter.toString(), e});
                }
            }
        });
    }
}

