/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.dimension;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ValueType;

public class DefaultDimensionSpec
implements DimensionSpec {
    private static final byte CACHE_TYPE_ID = 0;
    private final String dimension;
    private final String outputName;
    private final ValueType outputType;

    public static DefaultDimensionSpec of(String dimensionName) {
        return new DefaultDimensionSpec(dimensionName, dimensionName);
    }

    public static List<DimensionSpec> toSpec(String ... dimensionNames) {
        return DefaultDimensionSpec.toSpec(Arrays.asList(dimensionNames));
    }

    public static List<DimensionSpec> toSpec(Iterable<String> dimensionNames) {
        return StreamSupport.stream(dimensionNames.spliterator(), false).map(input -> new DefaultDimensionSpec((String)input, (String)input)).collect(Collectors.toList());
    }

    @JsonCreator
    public DefaultDimensionSpec(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="outputName") @Nullable String outputName, @JsonProperty(value="outputType") @Nullable ValueType outputType) {
        this.dimension = dimension;
        this.outputType = outputType == null ? ValueType.STRING : outputType;
        this.outputName = outputName == null ? dimension : outputName;
    }

    public DefaultDimensionSpec(String dimension, String outputName) {
        this(dimension, outputName, ValueType.STRING);
    }

    @Override
    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @Override
    @JsonProperty
    public String getOutputName() {
        return this.outputName;
    }

    @Override
    @JsonProperty
    public ValueType getOutputType() {
        return this.outputType;
    }

    @Override
    public ExtractionFn getExtractionFn() {
        return null;
    }

    @Override
    public DimensionSelector decorate(DimensionSelector selector) {
        return selector;
    }

    @Override
    public boolean mustDecorate() {
        return false;
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(0).appendString(this.dimension).appendString(this.outputType.toString()).build();
    }

    @Override
    public boolean preservesOrdering() {
        return true;
    }

    public String toString() {
        return "DefaultDimensionSpec{dimension='" + this.dimension + '\'' + ", outputName='" + this.outputName + '\'' + ", outputType='" + (Object)((Object)this.outputType) + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultDimensionSpec)) {
            return false;
        }
        DefaultDimensionSpec that = (DefaultDimensionSpec)o;
        if (this.dimension != null ? !this.dimension.equals(that.dimension) : that.dimension != null) {
            return false;
        }
        if (this.outputName != null ? !this.outputName.equals(that.outputName) : that.outputName != null) {
            return false;
        }
        return !(this.outputType != null ? !this.outputType.equals((Object)that.outputType) : that.outputType != null);
    }

    public int hashCode() {
        int result = this.dimension != null ? this.dimension.hashCode() : 0;
        result = 31 * result + (this.outputName != null ? this.outputName.hashCode() : 0);
        result = 31 * result + (this.outputType != null ? this.outputType.hashCode() : 0);
        return result;
    }
}

