/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.List;
import javax.annotation.Nonnull;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.query.filter.LikeDimFilter;

public class LikeExprMacro
implements ExprMacroTable.ExprMacro {
    public String name() {
        return "like";
    }

    public Expr apply(List<Expr> args) {
        String escape;
        Expr escapeExpr;
        if (args.size() < 2 || args.size() > 3) {
            throw new IAE("Function[%s] must have 2 or 3 arguments", new Object[]{this.name()});
        }
        final Expr arg = args.get(0);
        Expr patternExpr = args.get(1);
        Expr expr = escapeExpr = args.size() > 2 ? args.get(2) : null;
        if (!patternExpr.isLiteral() || escapeExpr != null && !escapeExpr.isLiteral()) {
            throw new IAE("pattern and escape must be literals", new Object[0]);
        }
        String string = escape = escapeExpr == null ? null : (String)escapeExpr.getLiteralValue();
        if (escape != null && escape.length() != 1) {
            throw new IllegalArgumentException("Escape must be null or a single character");
        }
        Character escapeChar = escape == null ? null : Character.valueOf(escape.charAt(0));
        final LikeDimFilter.LikeMatcher likeMatcher = LikeDimFilter.LikeMatcher.from(NullHandling.nullToEmptyIfNeeded((String)((String)patternExpr.getLiteralValue())), escapeChar);
        class LikeExtractExpr
        implements Expr {
            LikeExtractExpr() {
            }

            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                return ExprEval.of((boolean)likeMatcher.matches(arg.eval(bindings).asString()), (ExprType)ExprType.LONG);
            }

            public void visit(Expr.Visitor visitor) {
                arg.visit(visitor);
                visitor.visit((Expr)this);
            }
        }
        return new LikeExtractExpr();
    }
}

