/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.List;
import javax.annotation.Nonnull;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.expression.ExprUtils;
import org.joda.time.DateTime;

public class TimestampCeilExprMacro
implements ExprMacroTable.ExprMacro {
    public String name() {
        return "timestamp_ceil";
    }

    public Expr apply(List<Expr> args) {
        if (args.size() < 2 || args.size() > 4) {
            throw new IAE("Function[%s] must have 2 to 4 arguments", new Object[]{this.name()});
        }
        if (args.stream().skip(1L).allMatch(Expr::isLiteral)) {
            return new TimestampCeilExpr(args);
        }
        return new TimestampCeilDynamicExpr(args);
    }

    private static PeriodGranularity getGranularity(List<Expr> args, Expr.ObjectBinding bindings) {
        return ExprUtils.toPeriodGranularity(args.get(1), args.size() > 2 ? args.get(2) : null, args.size() > 3 ? args.get(3) : null, bindings);
    }

    private static class TimestampCeilDynamicExpr
    implements Expr {
        private final List<Expr> args;

        public TimestampCeilDynamicExpr(List<Expr> args) {
            this.args = args;
        }

        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            DateTime bucketStartTime;
            PeriodGranularity granularity = TimestampCeilExprMacro.getGranularity(this.args, bindings);
            DateTime argTime = DateTimes.utc((long)this.args.get(0).eval(bindings).asLong());
            if (argTime.equals((Object)(bucketStartTime = granularity.bucketStart(argTime)))) {
                return ExprEval.of((long)bucketStartTime.getMillis());
            }
            return ExprEval.of((long)granularity.increment(bucketStartTime).getMillis());
        }

        public void visit(Expr.Visitor visitor) {
            for (Expr arg : this.args) {
                arg.visit(visitor);
            }
            visitor.visit((Expr)this);
        }
    }

    private static class TimestampCeilExpr
    implements Expr {
        private final Expr arg;
        private final Granularity granularity;

        public TimestampCeilExpr(List<Expr> args) {
            this.arg = args.get(0);
            this.granularity = TimestampCeilExprMacro.getGranularity(args, ExprUtils.nilBindings());
        }

        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            DateTime bucketStartTime;
            ExprEval eval = this.arg.eval(bindings);
            if (eval.isNumericNull()) {
                return ExprEval.of(null);
            }
            DateTime argTime = DateTimes.utc((long)this.arg.eval(bindings).asLong());
            if (argTime.equals((Object)(bucketStartTime = this.granularity.bucketStart(argTime)))) {
                return ExprEval.of((long)bucketStartTime.getMillis());
            }
            return ExprEval.of((long)this.granularity.increment(bucketStartTime).getMillis());
        }

        public void visit(Expr.Visitor visitor) {
            this.arg.visit(visitor);
            visitor.visit((Expr)this);
        }
    }
}

