/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeRangeSet;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.filter.BoundFilter;

public class BoundDimFilter
implements DimFilter {
    private final String dimension;
    private final String upper;
    private final String lower;
    private final boolean lowerStrict;
    private final boolean upperStrict;
    private final ExtractionFn extractionFn;
    private final StringComparator ordering;
    private final Supplier<DruidLongPredicate> longPredicateSupplier;
    private final Supplier<DruidFloatPredicate> floatPredicateSupplier;
    private final Supplier<DruidDoublePredicate> doublePredicateSupplier;

    @JsonCreator
    public BoundDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="lower") String lower, @JsonProperty(value="upper") String upper, @JsonProperty(value="lowerStrict") Boolean lowerStrict, @JsonProperty(value="upperStrict") Boolean upperStrict, @Deprecated @JsonProperty(value="alphaNumeric") Boolean alphaNumeric, @JsonProperty(value="extractionFn") ExtractionFn extractionFn, @JsonProperty(value="ordering") StringComparator ordering) {
        this.dimension = (String)Preconditions.checkNotNull((Object)dimension, (Object)"dimension can not be null");
        Preconditions.checkState((lower != null || upper != null ? 1 : 0) != 0, (Object)"lower and upper can not be null at the same time");
        this.upper = upper;
        this.lower = lower;
        this.lowerStrict = lowerStrict == null ? false : lowerStrict;
        boolean bl = this.upperStrict = upperStrict == null ? false : upperStrict;
        if (ordering == null) {
            this.ordering = alphaNumeric == null || !alphaNumeric.booleanValue() ? StringComparators.LEXICOGRAPHIC : StringComparators.ALPHANUMERIC;
        } else {
            this.ordering = ordering;
            if (alphaNumeric != null) {
                boolean orderingIsAlphanumeric = this.ordering.equals(StringComparators.ALPHANUMERIC);
                Preconditions.checkState((alphaNumeric == orderingIsAlphanumeric ? 1 : 0) != 0, (Object)"mismatch between alphanumeric and ordering property");
            }
        }
        this.extractionFn = extractionFn;
        this.longPredicateSupplier = this.makeLongPredicateSupplier();
        this.floatPredicateSupplier = this.makeFloatPredicateSupplier();
        this.doublePredicateSupplier = this.makeDoublePredicateSupplier();
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public String getUpper() {
        return this.upper;
    }

    @JsonProperty
    public String getLower() {
        return this.lower;
    }

    @JsonProperty
    public boolean isLowerStrict() {
        return this.lowerStrict;
    }

    @JsonProperty
    public boolean isUpperStrict() {
        return this.upperStrict;
    }

    public boolean hasLowerBound() {
        return this.lower != null;
    }

    public boolean hasUpperBound() {
        return this.upper != null;
    }

    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    @JsonProperty
    public StringComparator getOrdering() {
        return this.ordering;
    }

    public Supplier<DruidLongPredicate> getLongPredicateSupplier() {
        return this.longPredicateSupplier;
    }

    public Supplier<DruidFloatPredicate> getFloatPredicateSupplier() {
        return this.floatPredicateSupplier;
    }

    public Supplier<DruidDoublePredicate> getDoublePredicateSupplier() {
        return this.doublePredicateSupplier;
    }

    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8((String)this.getDimension());
        byte[] lowerBytes = this.getLower() == null ? new byte[]{} : StringUtils.toUtf8((String)this.getLower());
        byte[] upperBytes = this.getUpper() == null ? new byte[]{} : StringUtils.toUtf8((String)this.getUpper());
        byte boundType = 1;
        if (this.getLower() == null) {
            boundType = 2;
        } else if (this.getUpper() == null) {
            boundType = 3;
        }
        byte lowerStrictByte = !this.isLowerStrict() ? (byte)0 : 1;
        byte upperStrictByte = !this.isUpperStrict() ? (byte)0 : 1;
        byte[] extractionFnBytes = this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey();
        byte[] orderingBytes = this.ordering.getCacheKey();
        ByteBuffer boundCacheBuffer = ByteBuffer.allocate(9 + dimensionBytes.length + upperBytes.length + lowerBytes.length + extractionFnBytes.length + orderingBytes.length);
        boundCacheBuffer.put((byte)10).put(boundType).put(upperStrictByte).put(lowerStrictByte).put((byte)-1).put(dimensionBytes).put((byte)-1).put(upperBytes).put((byte)-1).put(lowerBytes).put((byte)-1).put(extractionFnBytes).put((byte)-1).put(orderingBytes);
        return boundCacheBuffer.array();
    }

    @Override
    public DimFilter optimize() {
        return this;
    }

    @Override
    public Filter toFilter() {
        return new BoundFilter(this);
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        if (!Objects.equals(this.getDimension(), dimension) || this.getExtractionFn() != null || !this.ordering.equals(StringComparators.LEXICOGRAPHIC)) {
            return null;
        }
        TreeRangeSet retSet = TreeRangeSet.create();
        Range range = this.getLower() == null ? (this.isUpperStrict() ? Range.lessThan((Comparable)((Object)this.getUpper())) : Range.atMost((Comparable)((Object)this.getUpper()))) : (this.getUpper() == null ? (this.isLowerStrict() ? Range.greaterThan((Comparable)((Object)this.getLower())) : Range.atLeast((Comparable)((Object)this.getLower()))) : Range.range((Comparable)((Object)this.getLower()), (BoundType)(this.isLowerStrict() ? BoundType.OPEN : BoundType.CLOSED), (Comparable)((Object)this.getUpper()), (BoundType)(this.isUpperStrict() ? BoundType.OPEN : BoundType.CLOSED)));
        retSet.add(range);
        return retSet;
    }

    @Override
    public HashSet<String> getRequiredColumns() {
        return Sets.newHashSet((Object[])new String[]{this.dimension});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundDimFilter that = (BoundDimFilter)o;
        if (this.isLowerStrict() != that.isLowerStrict()) {
            return false;
        }
        if (this.isUpperStrict() != that.isUpperStrict()) {
            return false;
        }
        if (!this.getDimension().equals(that.getDimension())) {
            return false;
        }
        if (this.getUpper() != null ? !this.getUpper().equals(that.getUpper()) : that.getUpper() != null) {
            return false;
        }
        if (this.getLower() != null ? !this.getLower().equals(that.getLower()) : that.getLower() != null) {
            return false;
        }
        if (this.getExtractionFn() != null ? !this.getExtractionFn().equals(that.getExtractionFn()) : that.getExtractionFn() != null) {
            return false;
        }
        return this.getOrdering().equals(that.getOrdering());
    }

    public int hashCode() {
        int result = this.getDimension().hashCode();
        result = 31 * result + (this.getUpper() != null ? this.getUpper().hashCode() : 0);
        result = 31 * result + (this.getLower() != null ? this.getLower().hashCode() : 0);
        result = 31 * result + (this.isLowerStrict() ? 1 : 0);
        result = 31 * result + (this.isUpperStrict() ? 1 : 0);
        result = 31 * result + (this.getExtractionFn() != null ? this.getExtractionFn().hashCode() : 0);
        result = 31 * result + this.getOrdering().hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.lower != null) {
            builder.append(this.lower);
            if (this.lowerStrict) {
                builder.append(" < ");
            } else {
                builder.append(" <= ");
            }
        }
        if (this.extractionFn != null) {
            builder.append(StringUtils.format((String)"%s(%s)", (Object[])new Object[]{this.extractionFn, this.dimension}));
        } else {
            builder.append(this.dimension);
        }
        if (!this.ordering.equals(StringComparators.LEXICOGRAPHIC)) {
            builder.append(StringUtils.format((String)" as %s", (Object[])new Object[]{this.ordering.toString()}));
        }
        if (this.upper != null) {
            if (this.upperStrict) {
                builder.append(" < ");
            } else {
                builder.append(" <= ");
            }
            builder.append(this.upper);
        }
        return builder.toString();
    }

    private Supplier<DruidLongPredicate> makeLongPredicateSupplier() {
        class BoundLongPredicateSupplier
        implements Supplier<DruidLongPredicate> {
            private final Object initLock = new Object();
            private DruidLongPredicate predicate;

            BoundLongPredicateSupplier() {
            }

            public DruidLongPredicate get() {
                this.initPredicate();
                return this.predicate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private void initPredicate() {
                if (this.predicate != null) {
                    return;
                }
                Object object = this.initLock;
                synchronized (object) {
                    long upperLongBound;
                    boolean hasUpperLongBound;
                    long lowerLongBound;
                    boolean hasLowerLongBound;
                    boolean matchesNothing;
                    block15: {
                        block18: {
                            Long upperLong;
                            block19: {
                                block14: {
                                    block16: {
                                        Long lowerLong;
                                        block17: {
                                            if (this.predicate != null) {
                                                return;
                                            }
                                            matchesNothing = false;
                                            if (!BoundDimFilter.this.hasLowerBound()) break block16;
                                            lowerLong = GuavaUtils.tryParseLong((String)BoundDimFilter.this.lower);
                                            if (lowerLong != null) break block17;
                                            BigDecimal lowerBigDecimal = BoundDimFilter.this.getBigDecimalLowerBoundFromFloatString(BoundDimFilter.this.lower);
                                            if (lowerBigDecimal == null) {
                                                hasLowerLongBound = false;
                                                lowerLongBound = 0L;
                                                break block14;
                                            } else {
                                                try {
                                                    lowerLongBound = lowerBigDecimal.longValueExact();
                                                    hasLowerLongBound = true;
                                                }
                                                catch (ArithmeticException ae) {
                                                    hasLowerLongBound = false;
                                                    lowerLongBound = 0L;
                                                    if (lowerBigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                                                        matchesNothing = true;
                                                    }
                                                    break block14;
                                                }
                                            }
                                        }
                                        hasLowerLongBound = true;
                                        lowerLongBound = lowerLong;
                                        break block14;
                                    }
                                    hasLowerLongBound = false;
                                    lowerLongBound = 0L;
                                }
                                if (!BoundDimFilter.this.hasUpperBound()) break block18;
                                upperLong = GuavaUtils.tryParseLong((String)BoundDimFilter.this.upper);
                                if (upperLong != null) break block19;
                                BigDecimal upperBigDecimal = BoundDimFilter.this.getBigDecimalUpperBoundFromFloatString(BoundDimFilter.this.upper);
                                if (upperBigDecimal == null) {
                                    matchesNothing = true;
                                    hasUpperLongBound = false;
                                    upperLongBound = 0L;
                                    break block15;
                                } else {
                                    try {
                                        upperLongBound = upperBigDecimal.longValueExact();
                                        hasUpperLongBound = true;
                                    }
                                    catch (ArithmeticException ae) {
                                        hasUpperLongBound = false;
                                        upperLongBound = 0L;
                                        if (upperBigDecimal.compareTo(BigDecimal.ZERO) < 0) {
                                            matchesNothing = true;
                                        }
                                        break block15;
                                    }
                                }
                            }
                            hasUpperLongBound = true;
                            upperLongBound = upperLong;
                            break block15;
                        }
                        hasUpperLongBound = false;
                        upperLongBound = 0L;
                    }
                    this.predicate = matchesNothing ? DruidLongPredicate.ALWAYS_FALSE : BoundDimFilter.makeLongPredicateFromBounds(hasLowerLongBound, hasUpperLongBound, BoundDimFilter.this.lowerStrict, BoundDimFilter.this.upperStrict, lowerLongBound, upperLongBound);
                    return;
                }
            }
        }
        return new BoundLongPredicateSupplier();
    }

    @Nullable
    private BigDecimal getBigDecimalLowerBoundFromFloatString(String floatStr) {
        BigDecimal convertedBD;
        try {
            convertedBD = new BigDecimal(floatStr);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        if (this.lowerStrict) {
            return convertedBD.setScale(0, RoundingMode.FLOOR);
        }
        return convertedBD.setScale(0, RoundingMode.CEILING);
    }

    @Nullable
    private BigDecimal getBigDecimalUpperBoundFromFloatString(String floatStr) {
        BigDecimal convertedBD;
        try {
            convertedBD = new BigDecimal(floatStr);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        if (this.upperStrict) {
            return convertedBD.setScale(0, RoundingMode.CEILING);
        }
        return convertedBD.setScale(0, RoundingMode.FLOOR);
    }

    private Supplier<DruidFloatPredicate> makeFloatPredicateSupplier() {
        class BoundFloatPredicateSupplier
        implements Supplier<DruidFloatPredicate> {
            private final Object initLock = new Object();
            private DruidFloatPredicate predicate;

            BoundFloatPredicateSupplier() {
            }

            public DruidFloatPredicate get() {
                this.initPredicate();
                return this.predicate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void initPredicate() {
                if (this.predicate != null) {
                    return;
                }
                Object object = this.initLock;
                synchronized (object) {
                    float upperFloatBound;
                    boolean hasUpperFloatBound;
                    float lowerFloatBound;
                    boolean hasLowerFloatBound;
                    if (this.predicate != null) {
                        return;
                    }
                    boolean matchesNothing = false;
                    if (BoundDimFilter.this.hasLowerBound()) {
                        Float lowerFloat = Floats.tryParse((String)BoundDimFilter.this.lower);
                        if (lowerFloat == null) {
                            hasLowerFloatBound = false;
                            lowerFloatBound = 0.0f;
                        } else {
                            hasLowerFloatBound = true;
                            lowerFloatBound = lowerFloat.floatValue();
                        }
                    } else {
                        hasLowerFloatBound = false;
                        lowerFloatBound = 0.0f;
                    }
                    if (BoundDimFilter.this.hasUpperBound()) {
                        Float upperFloat = Floats.tryParse((String)BoundDimFilter.this.upper);
                        if (upperFloat == null) {
                            matchesNothing = true;
                            hasUpperFloatBound = false;
                            upperFloatBound = 0.0f;
                        } else {
                            hasUpperFloatBound = true;
                            upperFloatBound = upperFloat.floatValue();
                        }
                    } else {
                        hasUpperFloatBound = false;
                        upperFloatBound = 0.0f;
                    }
                    this.predicate = matchesNothing ? DruidFloatPredicate.ALWAYS_FALSE : input -> {
                        DruidDoublePredicate druidDoublePredicate = BoundDimFilter.makeDoublePredicateFromBounds(hasLowerFloatBound, hasUpperFloatBound, BoundDimFilter.this.lowerStrict, BoundDimFilter.this.upperStrict, lowerFloatBound, upperFloatBound);
                        return druidDoublePredicate.applyDouble(input);
                    };
                }
            }
        }
        return new BoundFloatPredicateSupplier();
    }

    private Supplier<DruidDoublePredicate> makeDoublePredicateSupplier() {
        class BoundDoublePredicateSupplier
        implements Supplier<DruidDoublePredicate> {
            private final Object initLock = new Object();
            private DruidDoublePredicate predicate;

            BoundDoublePredicateSupplier() {
            }

            public DruidDoublePredicate get() {
                this.initPredicate();
                return this.predicate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void initPredicate() {
                if (this.predicate != null) {
                    return;
                }
                Object object = this.initLock;
                synchronized (object) {
                    double upperDoubleBound;
                    boolean hasUpperBound;
                    double lowerDoubleBound;
                    boolean hasLowerBound;
                    if (this.predicate != null) {
                        return;
                    }
                    boolean matchesNothing = false;
                    if (BoundDimFilter.this.hasLowerBound()) {
                        Double lowerDouble = Doubles.tryParse((String)BoundDimFilter.this.lower);
                        if (lowerDouble == null) {
                            hasLowerBound = false;
                            lowerDoubleBound = 0.0;
                        } else {
                            hasLowerBound = true;
                            lowerDoubleBound = lowerDouble;
                        }
                    } else {
                        hasLowerBound = false;
                        lowerDoubleBound = 0.0;
                    }
                    if (BoundDimFilter.this.hasUpperBound()) {
                        Double upperDouble = Doubles.tryParse((String)BoundDimFilter.this.upper);
                        if (upperDouble == null) {
                            matchesNothing = true;
                            hasUpperBound = false;
                            upperDoubleBound = 0.0;
                        } else {
                            hasUpperBound = true;
                            upperDoubleBound = upperDouble;
                        }
                    } else {
                        hasUpperBound = false;
                        upperDoubleBound = 0.0;
                    }
                    this.predicate = matchesNothing ? DruidDoublePredicate.ALWAYS_FALSE : BoundDimFilter.makeDoublePredicateFromBounds(hasLowerBound, hasUpperBound, BoundDimFilter.this.lowerStrict, BoundDimFilter.this.upperStrict, lowerDoubleBound, upperDoubleBound);
                }
            }
        }
        return new BoundDoublePredicateSupplier();
    }

    private static DruidLongPredicate makeLongPredicateFromBounds(boolean hasLowerLongBound, boolean hasUpperLongBound, boolean lowerStrict, boolean upperStrict, final long lowerLongBound, final long upperLongBound) {
        if (hasLowerLongBound && hasUpperLongBound) {
            if (upperStrict && lowerStrict) {
                return new DruidLongPredicate(){

                    @Override
                    public boolean applyLong(long input) {
                        int lowerComparing = Long.compare(input, lowerLongBound);
                        int upperComparing = Long.compare(upperLongBound, input);
                        return lowerComparing > 0 && upperComparing > 0;
                    }
                };
            }
            if (lowerStrict) {
                return new DruidLongPredicate(){

                    @Override
                    public boolean applyLong(long input) {
                        int lowerComparing = Long.compare(input, lowerLongBound);
                        int upperComparing = Long.compare(upperLongBound, input);
                        return lowerComparing > 0 && upperComparing >= 0;
                    }
                };
            }
            if (upperStrict) {
                return new DruidLongPredicate(){

                    @Override
                    public boolean applyLong(long input) {
                        int lowerComparing = Long.compare(input, lowerLongBound);
                        int upperComparing = Long.compare(upperLongBound, input);
                        return lowerComparing >= 0 && upperComparing > 0;
                    }
                };
            }
            return new DruidLongPredicate(){

                @Override
                public boolean applyLong(long input) {
                    int lowerComparing = Long.compare(input, lowerLongBound);
                    int upperComparing = Long.compare(upperLongBound, input);
                    return lowerComparing >= 0 && upperComparing >= 0;
                }
            };
        }
        if (hasUpperLongBound) {
            if (upperStrict) {
                return new DruidLongPredicate(){

                    @Override
                    public boolean applyLong(long input) {
                        int upperComparing = Long.compare(upperLongBound, input);
                        return upperComparing > 0;
                    }
                };
            }
            return new DruidLongPredicate(){

                @Override
                public boolean applyLong(long input) {
                    int upperComparing = Long.compare(upperLongBound, input);
                    return upperComparing >= 0;
                }
            };
        }
        if (hasLowerLongBound) {
            if (lowerStrict) {
                return new DruidLongPredicate(){

                    @Override
                    public boolean applyLong(long input) {
                        int lowerComparing = Long.compare(input, lowerLongBound);
                        return lowerComparing > 0;
                    }
                };
            }
            return new DruidLongPredicate(){

                @Override
                public boolean applyLong(long input) {
                    int lowerComparing = Long.compare(input, lowerLongBound);
                    return lowerComparing >= 0;
                }
            };
        }
        return DruidLongPredicate.ALWAYS_TRUE;
    }

    private static DruidDoublePredicate makeDoublePredicateFromBounds(boolean hasLowerDoubleBound, boolean hasUpperDoubleBound, boolean lowerStrict, boolean upperStrict, double lowerDoubleBound, double upperDoubleBound) {
        if (hasLowerDoubleBound && hasUpperDoubleBound) {
            if (upperStrict && lowerStrict) {
                return input -> {
                    int lowerComparing = Double.compare(input, lowerDoubleBound);
                    int upperComparing = Double.compare(upperDoubleBound, input);
                    return lowerComparing > 0 && upperComparing > 0;
                };
            }
            if (lowerStrict) {
                return input -> {
                    int lowerComparing = Double.compare(input, lowerDoubleBound);
                    int upperComparing = Double.compare(upperDoubleBound, input);
                    return lowerComparing > 0 && upperComparing >= 0;
                };
            }
            if (upperStrict) {
                return input -> {
                    int lowerComparing = Double.compare(input, lowerDoubleBound);
                    int upperComparing = Double.compare(upperDoubleBound, input);
                    return lowerComparing >= 0 && upperComparing > 0;
                };
            }
            return input -> {
                int lowerComparing = Double.compare(input, lowerDoubleBound);
                int upperComparing = Double.compare(upperDoubleBound, input);
                return lowerComparing >= 0 && upperComparing >= 0;
            };
        }
        if (hasUpperDoubleBound) {
            if (upperStrict) {
                return input -> {
                    int upperComparing = Double.compare(upperDoubleBound, input);
                    return upperComparing > 0;
                };
            }
            return input -> {
                int upperComparing = Double.compare(upperDoubleBound, input);
                return upperComparing >= 0;
            };
        }
        if (hasLowerDoubleBound) {
            if (lowerStrict) {
                return input -> {
                    int lowerComparing = Double.compare(input, lowerDoubleBound);
                    return lowerComparing > 0;
                };
            }
            return input -> {
                int lowerComparing = Double.compare(input, lowerDoubleBound);
                return lowerComparing >= 0;
            };
        }
        return DruidDoublePredicate.ALWAYS_TRUE;
    }
}

