/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.java.util.common.granularity.AllGranularity;
import org.apache.druid.java.util.common.guava.nary.BinaryFn;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.joda.time.DateTime;

public class GroupByBinaryFnV2
implements BinaryFn<Row, Row, Row> {
    private final GroupByQuery query;

    public GroupByBinaryFnV2(GroupByQuery query) {
        this.query = query;
    }

    public Row apply(Row arg1, Row arg2) {
        if (arg1 == null) {
            return arg2;
        }
        if (arg2 == null) {
            return arg1;
        }
        HashMap newMap = Maps.newHashMapWithExpectedSize((int)(this.query.getDimensions().size() + this.query.getAggregatorSpecs().size()));
        for (DimensionSpec dimension : this.query.getDimensions()) {
            newMap.put(dimension.getOutputName(), arg1.getRaw(dimension.getOutputName()));
        }
        for (AggregatorFactory aggregatorFactory : this.query.getAggregatorSpecs()) {
            newMap.put(aggregatorFactory.getName(), aggregatorFactory.combine(arg1.getRaw(aggregatorFactory.getName()), arg2.getRaw(aggregatorFactory.getName())));
        }
        return new MapBasedRow(this.adjustTimestamp(arg1), (Map)newMap);
    }

    private DateTime adjustTimestamp(Row row) {
        if (this.query.getGranularity() instanceof AllGranularity) {
            return row.getTimestamp();
        }
        return this.query.getGranularity().bucketStart(row.getTimestamp());
    }
}

