/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.having;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import org.apache.druid.data.input.Row;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.groupby.having.BaseHavingSpec;
import org.apache.druid.query.groupby.having.HavingSpec;
import org.apache.druid.segment.column.ValueType;

public class NotHavingSpec
extends BaseHavingSpec {
    private final HavingSpec havingSpec;

    @JsonCreator
    public NotHavingSpec(@JsonProperty(value="havingSpec") HavingSpec havingSpec) {
        this.havingSpec = havingSpec;
    }

    @JsonProperty(value="havingSpec")
    public HavingSpec getHavingSpec() {
        return this.havingSpec;
    }

    @Override
    public void setRowSignature(Map<String, ValueType> rowSignature) {
        this.havingSpec.setRowSignature(rowSignature);
    }

    @Override
    public void setAggregators(Map<String, AggregatorFactory> aggregators) {
        this.havingSpec.setAggregators(aggregators);
    }

    @Override
    public boolean eval(Row row) {
        return !this.havingSpec.eval(row);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NotHavingSpec");
        sb.append("{havingSpec=").append(this.havingSpec);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotHavingSpec that = (NotHavingSpec)o;
        return !(this.havingSpec != null ? !this.havingSpec.equals(that.havingSpec) : that.havingSpec != null);
    }

    public int hashCode() {
        return this.havingSpec != null ? this.havingSpec.hashCode() : 0;
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(8).appendCacheable(this.havingSpec).build();
    }
}

