/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.strategy;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.guice.annotations.Merging;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.CloseQuietly;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.nary.BinaryFn;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.InsufficientResourcesException;
import org.apache.druid.query.IntervalChunkingQueryRunnerDecorator;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.ResourceLimitExceededException;
import org.apache.druid.query.ResultMergeQueryRunner;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryHelper;
import org.apache.druid.query.groupby.GroupByQueryQueryToolChest;
import org.apache.druid.query.groupby.epinephelinae.GroupByBinaryFnV2;
import org.apache.druid.query.groupby.epinephelinae.GroupByMergingQueryRunnerV2;
import org.apache.druid.query.groupby.epinephelinae.GroupByQueryEngineV2;
import org.apache.druid.query.groupby.epinephelinae.GroupByRowProcessor;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.resource.GroupByQueryResource;
import org.apache.druid.query.groupby.strategy.GroupByStrategy;
import org.apache.druid.segment.StorageAdapter;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class GroupByStrategyV2
implements GroupByStrategy {
    public static final String CTX_KEY_FUDGE_TIMESTAMP = "fudgeTimestamp";
    public static final String CTX_KEY_OUTERMOST = "groupByOutermost";
    private static final int MAX_MERGE_BUFFER_NUM = 2;
    private final DruidProcessingConfig processingConfig;
    private final Supplier<GroupByQueryConfig> configSupplier;
    private final NonBlockingPool<ByteBuffer> bufferPool;
    private final BlockingPool<ByteBuffer> mergeBufferPool;
    private final ObjectMapper spillMapper;
    private final QueryWatcher queryWatcher;

    @Inject
    public GroupByStrategyV2(DruidProcessingConfig processingConfig, Supplier<GroupByQueryConfig> configSupplier, @Global NonBlockingPool<ByteBuffer> bufferPool, @Merging BlockingPool<ByteBuffer> mergeBufferPool, @Smile ObjectMapper spillMapper, QueryWatcher queryWatcher) {
        this.processingConfig = processingConfig;
        this.configSupplier = configSupplier;
        this.bufferPool = bufferPool;
        this.mergeBufferPool = mergeBufferPool;
        this.spillMapper = spillMapper;
        this.queryWatcher = queryWatcher;
    }

    public static DateTime getUniversalTimestamp(GroupByQuery query) {
        Granularity gran = query.getGranularity();
        String timestampStringFromContext = query.getContextValue(CTX_KEY_FUDGE_TIMESTAMP, "");
        if (!timestampStringFromContext.isEmpty()) {
            return DateTimes.utc((long)Long.parseLong(timestampStringFromContext));
        }
        if (Granularities.ALL.equals(gran)) {
            DateTime timeStart = query.getIntervals().get(0).getStart();
            return ((Interval)gran.getIterable(new Interval((ReadableInstant)timeStart, (ReadableInstant)timeStart.plus(1L))).iterator().next()).getStart();
        }
        return null;
    }

    @Override
    public GroupByQueryResource prepareResource(GroupByQuery query, boolean willMergeRunners) {
        if (!willMergeRunners) {
            int requiredMergeBufferNum = GroupByStrategyV2.countRequiredMergeBufferNum(query, 1) + (query.getSubtotalsSpec() != null ? 1 : 0);
            if (requiredMergeBufferNum > this.mergeBufferPool.maxSize()) {
                throw new ResourceLimitExceededException("Query needs " + requiredMergeBufferNum + " merge buffers, but only " + this.mergeBufferPool.maxSize() + " merge buffers were configured", new Object[0]);
            }
            if (requiredMergeBufferNum == 0) {
                return new GroupByQueryResource();
            }
            List mergeBufferHolders = QueryContexts.hasTimeout(query) ? this.mergeBufferPool.takeBatch(requiredMergeBufferNum, QueryContexts.getTimeout(query)) : this.mergeBufferPool.takeBatch(requiredMergeBufferNum);
            if (mergeBufferHolders.isEmpty()) {
                throw new InsufficientResourcesException("Cannot acquire enough merge buffers");
            }
            return new GroupByQueryResource(mergeBufferHolders);
        }
        return new GroupByQueryResource();
    }

    private static int countRequiredMergeBufferNum(Query query, int foundNum) {
        DataSource dataSource = query.getDataSource();
        if (foundNum == 3 || !(dataSource instanceof QueryDataSource)) {
            return foundNum - 1;
        }
        return GroupByStrategyV2.countRequiredMergeBufferNum(((QueryDataSource)dataSource).getQuery(), foundNum + 1);
    }

    @Override
    public boolean isCacheable(boolean willMergeRunners) {
        return willMergeRunners;
    }

    @Override
    public boolean doMergeResults(GroupByQuery query) {
        return true;
    }

    @Override
    public QueryRunner<Row> createIntervalChunkingRunner(IntervalChunkingQueryRunnerDecorator decorator, QueryRunner<Row> runner, GroupByQueryQueryToolChest toolChest) {
        return runner;
    }

    @Override
    public Sequence<Row> mergeResults(QueryRunner<Row> baseRunner, final GroupByQuery query, Map<String, Object> responseContext) {
        ResultMergeQueryRunner<Row> mergingQueryRunner = new ResultMergeQueryRunner<Row>(baseRunner){

            @Override
            protected Ordering<Row> makeOrdering(Query<Row> queryParam) {
                return ((GroupByQuery)queryParam).getRowOrdering(true);
            }

            @Override
            protected BinaryFn<Row, Row, Row> createMergeFn(Query<Row> queryParam) {
                return new GroupByBinaryFnV2((GroupByQuery)queryParam);
            }
        };
        final DateTime fudgeTimestamp = GroupByStrategyV2.getUniversalTimestamp(query);
        ImmutableMap.Builder context = ImmutableMap.builder();
        context.put((Object)"finalize", (Object)false);
        context.put((Object)"groupByStrategy", (Object)"v2");
        if (fudgeTimestamp != null) {
            context.put((Object)CTX_KEY_FUDGE_TIMESTAMP, (Object)String.valueOf(fudgeTimestamp.getMillis()));
        }
        context.put((Object)CTX_KEY_OUTERMOST, (Object)false);
        context.put((Object)"applyLimitPushDown", (Object)query.isApplyLimitPushDown());
        Query newQuery = new GroupByQuery(query.getDataSource(), query.getQuerySegmentSpec(), query.getVirtualColumns(), query.getDimFilter(), query.getGranularity(), query.getDimensions(), query.getAggregatorSpecs(), query.getPostAggregatorSpecs(), null, query.getLimitSpec(), query.getSubtotalsSpec(), query.getContext()).withOverriddenContext((Map)context.build());
        return Sequences.map(mergingQueryRunner.run(QueryPlus.wrap(newQuery), responseContext), (Function)new Function<Row, Row>(){

            public Row apply(Row row) {
                Map newMap;
                if (query.getContextBoolean("executingNestedQuery", false)) {
                    return new MapBasedRow(fudgeTimestamp != null ? fudgeTimestamp : row.getTimestamp(), ((MapBasedRow)row).getEvent());
                }
                if (!query.getContextBoolean(GroupByStrategyV2.CTX_KEY_OUTERMOST, true)) {
                    return row;
                }
                if (query.getPostAggregatorSpecs().isEmpty() && fudgeTimestamp == null) {
                    return row;
                }
                if (query.getPostAggregatorSpecs().isEmpty()) {
                    newMap = ((MapBasedRow)row).getEvent();
                } else {
                    newMap = Maps.newLinkedHashMap((Map)((MapBasedRow)row).getEvent());
                    for (PostAggregator postAggregator : query.getPostAggregatorSpecs()) {
                        newMap.put(postAggregator.getName(), postAggregator.compute(newMap));
                    }
                }
                return new MapBasedRow(fudgeTimestamp != null ? fudgeTimestamp : row.getTimestamp(), newMap);
            }
        });
    }

    @Override
    public Sequence<Row> applyPostProcessing(Sequence<Row> results, GroupByQuery query) {
        if (query.getContextBoolean(CTX_KEY_OUTERMOST, true)) {
            return query.postProcess(results);
        }
        return results;
    }

    @Override
    public Sequence<Row> processSubqueryResult(GroupByQuery subquery, final GroupByQuery query, GroupByQueryResource resource, Sequence<Row> subqueryResult, boolean wasQueryPushedDown) {
        ArrayList closeOnExit = new ArrayList();
        try {
            final Supplier grouperSupplier = Suppliers.memoize(() -> GroupByRowProcessor.createGrouper(query, subqueryResult, GroupByQueryHelper.rowSignatureFor(wasQueryPushedDown ? query : subquery), (GroupByQueryConfig)this.configSupplier.get(), resource, this.spillMapper, this.processingConfig.getTmpDir(), this.processingConfig.intermediateComputeSizeBytes(), closeOnExit, wasQueryPushedDown));
            return Sequences.withBaggage(this.mergeResults(new QueryRunner<Row>(){

                @Override
                public Sequence<Row> run(QueryPlus<Row> queryPlus, Map<String, Object> responseContext) {
                    return GroupByRowProcessor.getRowsFromGrouper(query, null, (Supplier<Grouper>)grouperSupplier);
                }
            }, query, null), () -> Lists.reverse((List)closeOnExit).forEach(closeable -> CloseQuietly.close((Closeable)closeable)));
        }
        catch (Exception ex) {
            Lists.reverse(closeOnExit).forEach(closeable -> CloseQuietly.close((Closeable)closeable));
            throw ex;
        }
    }

    @Override
    public Sequence<Row> processSubtotalsSpec(GroupByQuery query, GroupByQueryResource resource, Sequence<Row> queryResult) {
        ArrayList closeOnExit = new ArrayList();
        try {
            final GroupByQuery queryWithoutSubtotalsSpec = query.withSubtotalsSpec(null).withDimFilter(null);
            List<List<String>> subtotals = query.getSubtotalsSpec();
            final Supplier grouperSupplier = Suppliers.memoize(() -> GroupByRowProcessor.createGrouper(queryWithoutSubtotalsSpec.withAggregatorSpecs(Lists.transform(queryWithoutSubtotalsSpec.getAggregatorSpecs(), agg -> agg.getCombiningFactory())).withDimensionSpecs(Lists.transform(queryWithoutSubtotalsSpec.getDimensions(), dimSpec -> new DefaultDimensionSpec(dimSpec.getOutputName(), dimSpec.getOutputName(), dimSpec.getOutputType()))), queryResult, GroupByQueryHelper.rowSignatureFor(queryWithoutSubtotalsSpec), (GroupByQueryConfig)this.configSupplier.get(), resource, this.spillMapper, this.processingConfig.getTmpDir(), this.processingConfig.intermediateComputeSizeBytes(), closeOnExit, false));
            ArrayList<Sequence<Row>> subtotalsResults = new ArrayList<Sequence<Row>>(subtotals.size());
            HashMap<String, DimensionSpec> queryDimensionSpecs = new HashMap<String, DimensionSpec>(queryWithoutSubtotalsSpec.getDimensions().size());
            for (DimensionSpec dimensionSpec : queryWithoutSubtotalsSpec.getDimensions()) {
                queryDimensionSpecs.put(dimensionSpec.getOutputName(), dimensionSpec);
            }
            for (final List list : subtotals) {
                GroupByQuery subtotalQuery = queryWithoutSubtotalsSpec.withDimensionSpecs(list.stream().map(s -> new DefaultDimensionSpec((String)s, (String)s, ((DimensionSpec)queryDimensionSpecs.get(s)).getOutputType())).collect(Collectors.toList()));
                subtotalsResults.add(this.applyPostProcessing(this.mergeResults(new QueryRunner<Row>(){

                    @Override
                    public Sequence<Row> run(QueryPlus<Row> queryPlus, Map<String, Object> responseContext) {
                        return GroupByRowProcessor.getRowsFromGrouper(queryWithoutSubtotalsSpec, list, (Supplier<Grouper>)grouperSupplier);
                    }
                }, subtotalQuery, null), subtotalQuery));
            }
            return Sequences.withBaggage((Sequence)Sequences.concat(subtotalsResults), () -> Lists.reverse((List)closeOnExit).forEach(closeable -> CloseQuietly.close((Closeable)closeable)));
        }
        catch (Exception ex) {
            Lists.reverse(closeOnExit).forEach(closeable -> CloseQuietly.close((Closeable)closeable));
            throw ex;
        }
    }

    @Override
    public QueryRunner<Row> mergeRunners(ListeningExecutorService exec, Iterable<QueryRunner<Row>> queryRunners) {
        return new GroupByMergingQueryRunnerV2((GroupByQueryConfig)this.configSupplier.get(), (ExecutorService)exec, this.queryWatcher, queryRunners, this.processingConfig.getNumThreads(), this.mergeBufferPool, this.processingConfig.intermediateComputeSizeBytes(), this.spillMapper, this.processingConfig.getTmpDir());
    }

    @Override
    public Sequence<Row> process(GroupByQuery query, StorageAdapter storageAdapter) {
        return GroupByQueryEngineV2.process(query, storageAdapter, this.bufferPool, ((GroupByQueryConfig)this.configSupplier.get()).withOverrides(query));
    }

    @Override
    public boolean supportsNestedQueryPushDown() {
        return true;
    }
}

