/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.ordering;

import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedBytes;
import java.math.BigDecimal;
import java.util.Comparator;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class StringComparators {
    public static final String LEXICOGRAPHIC_NAME = "lexicographic";
    public static final String ALPHANUMERIC_NAME = "alphanumeric";
    public static final String NUMERIC_NAME = "numeric";
    public static final String STRLEN_NAME = "strlen";
    public static final String VERSION_NAME = "version";
    public static final StringComparator LEXICOGRAPHIC = new LexicographicComparator();
    public static final StringComparator ALPHANUMERIC = new AlphanumericComparator();
    public static final StringComparator NUMERIC = new NumericComparator();
    public static final StringComparator STRLEN = new StrlenComparator();
    public static final StringComparator VERSION = new VersionComparator();
    public static final int LEXICOGRAPHIC_CACHE_ID = 1;
    public static final int ALPHANUMERIC_CACHE_ID = 2;
    public static final int NUMERIC_CACHE_ID = 3;
    public static final int STRLEN_CACHE_ID = 4;
    public static final int VERSION_CACHE_ID = 5;

    private static BigDecimal convertStringToBigDecimal(String input) {
        if (input == null) {
            return null;
        }
        BigDecimal bd = null;
        try {
            bd = new BigDecimal(input);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return bd;
    }

    public static class VersionComparator
    extends StringComparator {
        @Override
        public int compare(String o1, String o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            DefaultArtifactVersion version1 = new DefaultArtifactVersion(o1);
            DefaultArtifactVersion version2 = new DefaultArtifactVersion(o2);
            return version1.compareTo((ArtifactVersion)version2);
        }

        public String toString() {
            return StringComparators.VERSION_NAME;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        @Override
        public byte[] getCacheKey() {
            return new byte[]{5};
        }
    }

    public static class NumericComparator
    extends StringComparator {
        @Override
        public int compare(String o1, String o2) {
            BigDecimal bd2;
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            Long long1 = GuavaUtils.tryParseLong((String)o1);
            Long long2 = GuavaUtils.tryParseLong((String)o2);
            if (long1 != null && long2 != null) {
                return Long.compare(long1, long2);
            }
            BigDecimal bd1 = long1 == null ? StringComparators.convertStringToBigDecimal(o1) : new BigDecimal(long1);
            BigDecimal bigDecimal = bd2 = long2 == null ? StringComparators.convertStringToBigDecimal(o2) : new BigDecimal(long2);
            if (bd1 != null && bd2 != null) {
                return bd1.compareTo(bd2);
            }
            if (bd1 == null && bd2 == null) {
                return LEXICOGRAPHIC.compare(o1, o2);
            }
            if (bd1 == null) {
                return -1;
            }
            return 1;
        }

        public String toString() {
            return StringComparators.NUMERIC_NAME;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        @Override
        public byte[] getCacheKey() {
            return new byte[]{3};
        }
    }

    public static class StrlenComparator
    extends StringComparator {
        private static final Ordering<String> ORDERING = Ordering.from((Comparator)new Comparator<String>(){

            @Override
            public int compare(String s, String s2) {
                return Ints.compare((int)s.length(), (int)s2.length());
            }
        }).nullsFirst().compound((Comparator)Ordering.natural());

        @Override
        public int compare(String s, String s2) {
            if (s == s2) {
                return 0;
            }
            return ORDERING.compare((Object)s, (Object)s2);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public String toString() {
            return StringComparators.STRLEN_NAME;
        }

        @Override
        public byte[] getCacheKey() {
            return new byte[]{4};
        }
    }

    public static class AlphanumericComparator
    extends StringComparator {
        @Override
        public int compare(String str1, String str2) {
            int[] pos = new int[]{0, 0};
            if (str1 == null) {
                if (str2 == null) {
                    return 0;
                }
                return -1;
            }
            if (str2 == null) {
                return 1;
            }
            if (str1.length() == 0) {
                return str2.length() == 0 ? 0 : -1;
            }
            if (str2.length() == 0) {
                return 1;
            }
            while (pos[0] < str1.length() && pos[1] < str2.length()) {
                int result;
                int ch1 = str1.codePointAt(pos[0]);
                int ch2 = str2.codePointAt(pos[1]);
                if (this.isDigit(ch1)) {
                    result = this.isDigit(ch2) ? this.compareNumbers(str1, str2, pos) : -1;
                } else {
                    int n = result = this.isDigit(ch2) ? 1 : this.compareNonNumeric(str1, str2, pos);
                }
                if (result == 0) continue;
                return result;
            }
            return Integer.compare(str1.length(), str2.length());
        }

        private int compareNumbers(String str0, String str1, int[] pos) {
            int delta = 0;
            int zeroes0 = 0;
            int zeroes1 = 0;
            int ch0 = -1;
            int ch1 = -1;
            while (pos[0] < str0.length() && this.isZero(ch0 = str0.codePointAt(pos[0]))) {
                ++zeroes0;
                pos[0] = pos[0] + Character.charCount(ch0);
            }
            while (pos[1] < str1.length() && this.isZero(ch1 = str1.codePointAt(pos[1]))) {
                ++zeroes1;
                pos[1] = pos[1] + Character.charCount(ch1);
            }
            while (true) {
                boolean noMoreDigits1;
                boolean noMoreDigits0 = ch0 < 0 || !this.isDigit(ch0);
                boolean bl = noMoreDigits1 = ch1 < 0 || !this.isDigit(ch1);
                if (noMoreDigits0 && noMoreDigits1) {
                    return delta != 0 ? delta : zeroes0 - zeroes1;
                }
                if (noMoreDigits0) {
                    return -1;
                }
                if (noMoreDigits1) {
                    return 1;
                }
                if (delta == 0 && ch0 != ch1) {
                    delta = this.valueOf(ch0) - this.valueOf(ch1);
                }
                if (pos[0] < str0.length()) {
                    ch0 = str0.codePointAt(pos[0]);
                    if (this.isDigit(ch0)) {
                        pos[0] = pos[0] + Character.charCount(ch0);
                    } else {
                        ch0 = -1;
                    }
                } else {
                    ch0 = -1;
                }
                if (pos[1] < str1.length()) {
                    ch1 = str1.codePointAt(pos[1]);
                    if (this.isDigit(ch1)) {
                        pos[1] = pos[1] + Character.charCount(ch1);
                        continue;
                    }
                    ch1 = -1;
                    continue;
                }
                ch1 = -1;
            }
        }

        private boolean isDigit(int ch) {
            return ch >= 48 && ch <= 57 || ch >= 1632 && ch <= 1641 || ch >= 1776 && ch <= 1785 || ch >= 2406 && ch <= 2415 || ch >= 65296 && ch <= 65305;
        }

        private boolean isZero(int ch) {
            return ch == 48 || ch == 1632 || ch == 1776 || ch == 2406 || ch == 65296;
        }

        private int valueOf(int digit) {
            if (digit <= 57) {
                return digit - 48;
            }
            if (digit <= 1641) {
                return digit - 1632;
            }
            if (digit <= 1785) {
                return digit - 1776;
            }
            if (digit <= 2415) {
                return digit - 2406;
            }
            if (digit <= 65305) {
                return digit - 65296;
            }
            return digit;
        }

        private int compareNonNumeric(String str0, String str1, int[] pos) {
            int start0 = pos[0];
            int ch0 = str0.codePointAt(pos[0]);
            pos[0] = pos[0] + Character.charCount(ch0);
            while (pos[0] < str0.length() && !this.isDigit(ch0 = str0.codePointAt(pos[0]))) {
                pos[0] = pos[0] + Character.charCount(ch0);
            }
            int start1 = pos[1];
            int ch1 = str1.codePointAt(pos[1]);
            pos[1] = pos[1] + Character.charCount(ch1);
            while (pos[1] < str1.length() && !this.isDigit(ch1 = str1.codePointAt(pos[1]))) {
                pos[1] = pos[1] + Character.charCount(ch1);
            }
            return String.CASE_INSENSITIVE_ORDER.compare(str0.substring(start0, pos[0]), str1.substring(start1, pos[1]));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public String toString() {
            return StringComparators.ALPHANUMERIC_NAME;
        }

        @Override
        public byte[] getCacheKey() {
            return new byte[]{2};
        }
    }

    public static class LexicographicComparator
    extends StringComparator {
        private static final Ordering<String> ORDERING = Ordering.from((Comparator)new Comparator<String>(){

            @Override
            public int compare(String s, String s2) {
                return UnsignedBytes.lexicographicalComparator().compare(StringUtils.toUtf8((String)s), StringUtils.toUtf8((String)s2));
            }
        }).nullsFirst();

        @Override
        public int compare(String s, String s2) {
            if (s == s2) {
                return 0;
            }
            return ORDERING.compare((Object)s, (Object)s2);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public String toString() {
            return StringComparators.LEXICOGRAPHIC_NAME;
        }

        @Override
        public byte[] getCacheKey() {
            return new byte[]{1};
        }
    }
}

