/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeoutException;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class ScanQueryEngine {
    private static final String LEGACY_TIMESTAMP_KEY = "timestamp";

    public Sequence<ScanResultValue> process(final ScanQuery query, Segment segment, final Map<String, Object> responseContext) {
        long count;
        final boolean legacy = (Boolean)Preconditions.checkNotNull((Object)query.isLegacy(), (Object)"WTF?! Expected non-null legacy");
        if (responseContext.get("count") != null && (count = ((Long)responseContext.get("count")).longValue()) >= query.getLimit() && query.getOrder().equals((Object)ScanQuery.Order.NONE)) {
            return Sequences.empty();
        }
        final boolean hasTimeout = QueryContexts.hasTimeout(query);
        final long timeoutAt = (Long)responseContext.get("timeoutAt");
        final long start = System.currentTimeMillis();
        StorageAdapter adapter = segment.asStorageAdapter();
        if (adapter == null) {
            throw new ISE("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
        }
        final ArrayList<String> allColumns = new ArrayList<String>();
        if (query.getColumns() != null && !query.getColumns().isEmpty()) {
            if (legacy && !query.getColumns().contains(LEGACY_TIMESTAMP_KEY)) {
                allColumns.add(LEGACY_TIMESTAMP_KEY);
            }
            allColumns.addAll(query.getColumns());
        } else {
            LinkedHashSet availableColumns = Sets.newLinkedHashSet((Iterable)Iterables.concat(Collections.singleton(legacy ? LEGACY_TIMESTAMP_KEY : "__time"), (Iterable)Iterables.transform(Arrays.asList(query.getVirtualColumns().getVirtualColumns()), VirtualColumn::getOutputName), adapter.getAvailableDimensions(), adapter.getAvailableMetrics()));
            allColumns.addAll(availableColumns);
            if (legacy) {
                allColumns.remove("__time");
            }
        }
        List<Interval> intervals = query.getQuerySegmentSpec().getIntervals();
        Preconditions.checkArgument((intervals.size() == 1 ? 1 : 0) != 0, (String)"Can only handle a single interval, got[%s]", (Object[])new Object[]{intervals});
        final SegmentId segmentId = segment.getId();
        Filter filter = Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getFilter()));
        if (responseContext.get("count") == null) {
            responseContext.put("count", 0L);
        }
        final long limit = this.calculateLimit(query, responseContext);
        return Sequences.concat((Sequence)adapter.makeCursors(filter, intervals.get(0), query.getVirtualColumns(), Granularities.ALL, query.getOrder().equals((Object)ScanQuery.Order.DESCENDING) || query.getOrder().equals((Object)ScanQuery.Order.NONE) && query.isDescending(), null).map(cursor -> new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<ScanResultValue, Iterator<ScanResultValue>>(){

            public Iterator<ScanResultValue> make() {
                final ArrayList<ColumnValueSelector> columnSelectors = new ArrayList<ColumnValueSelector>(allColumns.size());
                for (String column : allColumns) {
                    ColumnValueSelector selector = legacy && ScanQueryEngine.LEGACY_TIMESTAMP_KEY.equals(column) ? cursor.getColumnSelectorFactory().makeColumnValueSelector("__time") : cursor.getColumnSelectorFactory().makeColumnValueSelector(column);
                    columnSelectors.add(selector);
                }
                final int batchSize = query.getBatchSize();
                return new Iterator<ScanResultValue>(){
                    private long offset = 0L;

                    @Override
                    public boolean hasNext() {
                        return !cursor.isDone() && this.offset < limit;
                    }

                    @Override
                    public ScanResultValue next() {
                        List<Object> events;
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        if (hasTimeout && System.currentTimeMillis() >= timeoutAt) {
                            throw new QueryInterruptedException(new TimeoutException());
                        }
                        long lastOffset = this.offset;
                        ScanQuery.ResultFormat resultFormat = query.getResultFormat();
                        if (ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST.equals((Object)resultFormat)) {
                            events = this.rowsToCompactedList();
                        } else if (ScanQuery.ResultFormat.RESULT_FORMAT_LIST.equals((Object)resultFormat)) {
                            events = this.rowsToList();
                        } else {
                            throw new UOE("resultFormat[%s] is not supported", new Object[]{resultFormat.toString()});
                        }
                        responseContext.put("count", (Long)responseContext.get("count") + (this.offset - lastOffset));
                        if (hasTimeout) {
                            responseContext.put("timeoutAt", timeoutAt - (System.currentTimeMillis() - start));
                        }
                        return new ScanResultValue(segmentId.toString(), allColumns, events);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private List<Object> rowsToCompactedList() {
                        ArrayList<Object> events = new ArrayList<Object>(batchSize);
                        long iterLimit = Math.min(limit, this.offset + (long)batchSize);
                        while (!cursor.isDone() && this.offset < iterLimit) {
                            ArrayList<Object> theEvent = new ArrayList<Object>(allColumns.size());
                            for (int j = 0; j < allColumns.size(); ++j) {
                                theEvent.add(this.getColumnValue(j));
                            }
                            events.add(theEvent);
                            cursor.advance();
                            ++this.offset;
                        }
                        return events;
                    }

                    private List<Map<String, Object>> rowsToList() {
                        ArrayList events = Lists.newArrayListWithCapacity((int)batchSize);
                        long iterLimit = Math.min(limit, this.offset + (long)batchSize);
                        while (!cursor.isDone() && this.offset < iterLimit) {
                            LinkedHashMap theEvent = new LinkedHashMap();
                            for (int j = 0; j < allColumns.size(); ++j) {
                                theEvent.put(allColumns.get(j), this.getColumnValue(j));
                            }
                            events.add(theEvent);
                            cursor.advance();
                            ++this.offset;
                        }
                        return events;
                    }

                    private Object getColumnValue(int i) {
                        BaseObjectColumnValueSelector selector = (BaseObjectColumnValueSelector)columnSelectors.get(i);
                        DateTime value = legacy && ((String)allColumns.get(i)).equals(ScanQueryEngine.LEGACY_TIMESTAMP_KEY) ? DateTimes.utc((long)((Long)selector.getObject())) : (selector == null ? null : (DateTime)selector.getObject());
                        return value;
                    }
                };
            }

            public void cleanup(Iterator<ScanResultValue> iterFromMake) {
            }
        })));
    }

    private long calculateLimit(ScanQuery query, Map<String, Object> responseContext) {
        if (query.getOrder().equals((Object)ScanQuery.Order.NONE)) {
            return query.getLimit() - (Long)responseContext.get("count");
        }
        return query.getLimit();
    }
}

