/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import com.google.common.base.Supplier;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexRow;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.IndexSizeExceededException;

public class OnheapIncrementalIndex
extends IncrementalIndex<Aggregator> {
    private static final Logger log = new Logger(OnheapIncrementalIndex.class);
    private static final int ROUGH_OVERHEAD_PER_MAP_ENTRY = 44;
    private final ConcurrentHashMap<Integer, Aggregator[]> aggregators = new ConcurrentHashMap();
    private final IncrementalIndex.FactsHolder facts;
    private final AtomicInteger indexIncrement = new AtomicInteger(0);
    private final long maxBytesPerRowForAggregators;
    protected final int maxRowCount;
    protected final long maxBytesInMemory;
    private volatile Map<String, ColumnSelectorFactory> selectors;
    private String outOfRowsReason = null;

    OnheapIncrementalIndex(IncrementalIndexSchema incrementalIndexSchema, boolean deserializeComplexMetrics, boolean reportParseExceptions, boolean concurrentEventAdd, boolean sortFacts, int maxRowCount, long maxBytesInMemory) {
        super(incrementalIndexSchema, deserializeComplexMetrics, reportParseExceptions, concurrentEventAdd);
        this.maxRowCount = maxRowCount;
        this.maxBytesInMemory = maxBytesInMemory == 0L ? Long.MAX_VALUE : maxBytesInMemory;
        this.facts = incrementalIndexSchema.isRollup() ? new IncrementalIndex.RollupFactsHolder(sortFacts, this.dimsComparator(), this.getDimensions()) : new IncrementalIndex.PlainFactsHolder(sortFacts, this.dimsComparator());
        this.maxBytesPerRowForAggregators = OnheapIncrementalIndex.getMaxBytesPerRowForAggregators(incrementalIndexSchema);
    }

    private static long getMaxBytesPerRowForAggregators(IncrementalIndexSchema incrementalIndexSchema) {
        long maxAggregatorIntermediateSize = 4 * incrementalIndexSchema.getMetrics().length;
        return maxAggregatorIntermediateSize += Arrays.stream(incrementalIndexSchema.getMetrics()).mapToLong(aggregator -> aggregator.getMaxIntermediateSizeWithNulls() + 16).sum();
    }

    @Override
    public IncrementalIndex.FactsHolder getFacts() {
        return this.facts;
    }

    protected Aggregator[] initAggs(AggregatorFactory[] metrics, Supplier<InputRow> rowSupplier, boolean deserializeComplexMetrics, boolean concurrentEventAdd) {
        this.selectors = new HashMap<String, ColumnSelectorFactory>();
        for (AggregatorFactory agg : metrics) {
            this.selectors.put(agg.getName(), new CachingColumnSelectorFactory(this.makeColumnSelectorFactory(agg, rowSupplier, deserializeComplexMetrics), concurrentEventAdd));
        }
        return new Aggregator[metrics.length];
    }

    @Override
    protected IncrementalIndex.AddToFactsResult addToFacts(InputRow row, IncrementalIndexRow key, ThreadLocal<InputRow> rowContainer, Supplier<InputRow> rowSupplier, boolean skipMaxRowsInMemoryCheck) throws IndexSizeExceededException {
        List<String> parseExceptionMessages;
        int priorIndex = this.facts.getPriorIndex(key);
        AggregatorFactory[] metrics = this.getMetrics();
        AtomicInteger numEntries = this.getNumEntries();
        AtomicLong sizeInBytes = this.getBytesInMemory();
        if (-1 != priorIndex) {
            Aggregator[] aggs = this.concurrentGet(priorIndex);
            parseExceptionMessages = this.doAggregate(metrics, aggs, rowContainer, row);
        } else {
            Aggregator[] aggs = new Aggregator[metrics.length];
            this.factorizeAggs(metrics, aggs, rowContainer, row);
            parseExceptionMessages = this.doAggregate(metrics, aggs, rowContainer, row);
            int rowIndex = this.indexIncrement.getAndIncrement();
            this.concurrentSet(rowIndex, aggs);
            if (!(numEntries.get() < this.maxRowCount && sizeInBytes.get() < this.maxBytesInMemory || this.facts.getPriorIndex(key) != -1 || skipMaxRowsInMemoryCheck)) {
                throw new IndexSizeExceededException("Maximum number of rows [%d] or max size in bytes [%d] reached", this.maxRowCount, this.maxBytesInMemory);
            }
            int prev = this.facts.putIfAbsent(key, rowIndex);
            if (-1 == prev) {
                numEntries.incrementAndGet();
                long estimatedRowSize = this.estimateRowSizeInBytes(key, this.maxBytesPerRowForAggregators);
                sizeInBytes.addAndGet(estimatedRowSize);
            } else {
                aggs = this.concurrentGet(prev);
                parseExceptionMessages = this.doAggregate(metrics, aggs, rowContainer, row);
                this.concurrentRemove(rowIndex);
            }
        }
        return new IncrementalIndex.AddToFactsResult(numEntries.get(), sizeInBytes.get(), parseExceptionMessages);
    }

    private long estimateRowSizeInBytes(IncrementalIndexRow key, long maxBytesPerRowForAggregators) {
        return 44L + key.estimateBytesInMemory() + maxBytesPerRowForAggregators;
    }

    @Override
    public int getLastRowIndex() {
        return this.indexIncrement.get() - 1;
    }

    private void factorizeAggs(AggregatorFactory[] metrics, Aggregator[] aggs, ThreadLocal<InputRow> rowContainer, InputRow row) {
        rowContainer.set(row);
        for (int i = 0; i < metrics.length; ++i) {
            AggregatorFactory agg = metrics[i];
            aggs[i] = agg.factorize(this.selectors.get(agg.getName()));
        }
        rowContainer.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> doAggregate(AggregatorFactory[] metrics, Aggregator[] aggs, ThreadLocal<InputRow> rowContainer, InputRow row) {
        ArrayList<String> parseExceptionMessages = new ArrayList<String>();
        rowContainer.set(row);
        for (int i = 0; i < aggs.length; ++i) {
            Aggregator agg;
            Aggregator aggregator = agg = aggs[i];
            synchronized (aggregator) {
                try {
                    agg.aggregate();
                }
                catch (ParseException e) {
                    log.debug((Throwable)e, "Encountered parse error, skipping aggregator[%s].", new Object[]{metrics[i].getName()});
                    parseExceptionMessages.add(e.getMessage());
                }
                continue;
            }
        }
        rowContainer.set(null);
        return parseExceptionMessages;
    }

    private void closeAggregators() {
        Closer closer = Closer.create();
        for (Aggregator[] aggs : this.aggregators.values()) {
            for (Aggregator agg : aggs) {
                closer.register((Closeable)agg);
            }
        }
        try {
            closer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Aggregator[] concurrentGet(int offset) {
        return this.aggregators.get(offset);
    }

    protected void concurrentSet(int offset, Aggregator[] value) {
        this.aggregators.put(offset, value);
    }

    protected void concurrentRemove(int offset) {
        this.aggregators.remove(offset);
    }

    @Override
    public boolean canAppendRow() {
        boolean canAdd;
        boolean countCheck = this.size() < this.maxRowCount;
        boolean sizeCheck = this.maxBytesInMemory <= 0L || this.getBytesInMemory().get() < this.maxBytesInMemory;
        boolean bl = canAdd = countCheck && sizeCheck;
        if (!countCheck && !sizeCheck) {
            this.outOfRowsReason = StringUtils.format((String)"Maximum number of rows [%d] and maximum size in bytes [%d] reached", (Object[])new Object[]{this.maxRowCount, this.maxBytesInMemory});
        } else if (!countCheck) {
            this.outOfRowsReason = StringUtils.format((String)"Maximum number of rows [%d] reached", (Object[])new Object[]{this.maxRowCount});
        } else if (!sizeCheck) {
            this.outOfRowsReason = StringUtils.format((String)"Maximum size in bytes [%d] reached", (Object[])new Object[]{this.maxBytesInMemory});
        }
        return canAdd;
    }

    @Override
    public String getOutOfRowsReason() {
        return this.outOfRowsReason;
    }

    protected Aggregator[] getAggsForRow(int rowOffset) {
        return this.concurrentGet(rowOffset);
    }

    @Override
    protected Object getAggVal(Aggregator agg, int rowOffset, int aggPosition) {
        return agg.get();
    }

    @Override
    public float getMetricFloatValue(int rowOffset, int aggOffset) {
        return this.concurrentGet(rowOffset)[aggOffset].getFloat();
    }

    @Override
    public long getMetricLongValue(int rowOffset, int aggOffset) {
        return this.concurrentGet(rowOffset)[aggOffset].getLong();
    }

    @Override
    public Object getMetricObjectValue(int rowOffset, int aggOffset) {
        return this.concurrentGet(rowOffset)[aggOffset].get();
    }

    @Override
    protected double getMetricDoubleValue(int rowOffset, int aggOffset) {
        return this.concurrentGet(rowOffset)[aggOffset].getDouble();
    }

    @Override
    public boolean isNull(int rowOffset, int aggOffset) {
        return this.concurrentGet(rowOffset)[aggOffset].isNull();
    }

    @Override
    public void close() {
        super.close();
        this.closeAggregators();
        this.aggregators.clear();
        this.facts.clear();
        if (this.selectors != null) {
            this.selectors.clear();
        }
    }

    static class CachingColumnSelectorFactory
    implements ColumnSelectorFactory {
        private final Map<String, ColumnValueSelector<?>> columnSelectorMap;
        private final ColumnSelectorFactory delegate;

        public CachingColumnSelectorFactory(ColumnSelectorFactory delegate, boolean concurrentEventAdd) {
            this.delegate = delegate;
            this.columnSelectorMap = concurrentEventAdd ? new ConcurrentHashMap() : new HashMap();
        }

        @Override
        public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
            return this.delegate.makeDimensionSelector(dimensionSpec);
        }

        @Override
        public ColumnValueSelector<?> makeColumnValueSelector(String columnName) {
            ColumnValueSelector<?> existing = this.columnSelectorMap.get(columnName);
            if (existing != null) {
                return existing;
            }
            return this.columnSelectorMap.computeIfAbsent(columnName, this.delegate::makeColumnValueSelector);
        }

        @Override
        @Nullable
        public ColumnCapabilities getColumnCapabilities(String columnName) {
            return this.delegate.getColumnCapabilities(columnName);
        }
    }
}

