/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections.spatial.split;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.spatial.Node;
import org.apache.druid.collections.spatial.RTreeUtils;
import org.apache.druid.collections.spatial.split.SplitStrategy;

public abstract class GutmanSplitStrategy
implements SplitStrategy {
    private final int minNumChildren;
    private final int maxNumChildren;
    private final BitmapFactory bf;

    protected GutmanSplitStrategy(int minNumChildren, int maxNumChildren, BitmapFactory b) {
        this.minNumChildren = minNumChildren;
        this.maxNumChildren = maxNumChildren;
        this.bf = b;
    }

    @Override
    public boolean needToSplit(Node node) {
        return node.getChildren().size() > this.maxNumChildren;
    }

    @Override
    public Node[] split(Node node) {
        ArrayList children = Lists.newArrayList(node.getChildren());
        Node[] seeds = this.pickSeeds(children);
        node.clear();
        node.addChild(seeds[0]);
        node.addToBitmapIndex(seeds[0]);
        Node group1 = new Node((float[])seeds[1].getMinCoordinates().clone(), (float[])seeds[1].getMaxCoordinates().clone(), seeds[1], node.isLeaf(), node.getParent(), this.bf.makeEmptyMutableBitmap());
        group1.addToBitmapIndex(seeds[1]);
        if (node.getParent() != null) {
            node.getParent().addChild(group1);
        }
        Node[] groups = new Node[]{node, group1};
        RTreeUtils.enclose(groups);
        while (!children.isEmpty()) {
            double group1ExpandedArea;
            for (Node group : groups) {
                if (group.getChildren().size() + children.size() > this.minNumChildren) continue;
                for (Node child : children) {
                    group.addToBitmapIndex(child);
                    group.addChild(child);
                }
                RTreeUtils.enclose(groups);
                return groups;
            }
            Node nextToAssign = this.pickNext(children);
            double group0ExpandedArea = RTreeUtils.getEnclosingArea(groups[0], nextToAssign);
            Node optimal = group0ExpandedArea < (group1ExpandedArea = RTreeUtils.getEnclosingArea(groups[1], nextToAssign)) ? groups[0] : (group0ExpandedArea == group1ExpandedArea ? (groups[0].getArea() < groups[1].getArea() ? groups[0] : groups[1]) : groups[1]);
            optimal.addToBitmapIndex(nextToAssign);
            optimal.addChild(nextToAssign);
            optimal.enclose();
        }
        return groups;
    }

    public abstract Node[] pickSeeds(List<Node> var1);

    public abstract Node pickNext(List<Node> var1);
}

