/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import java.util.Comparator;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import org.apache.druid.common.guava.CombiningSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.BySegmentSkippingQueryRunner;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.context.ResponseContext;

public class ResultMergeQueryRunner<T>
extends BySegmentSkippingQueryRunner<T> {
    private final Function<Query<T>, Comparator<T>> comparatorGenerator;
    private final Function<Query<T>, BinaryOperator<T>> mergeFnGenerator;

    public ResultMergeQueryRunner(QueryRunner<T> baseRunner, Function<Query<T>, Comparator<T>> comparatorGenerator, Function<Query<T>, BinaryOperator<T>> mergeFnGenerator) {
        super(baseRunner);
        this.comparatorGenerator = comparatorGenerator;
        this.mergeFnGenerator = mergeFnGenerator;
    }

    @Override
    public Sequence<T> doRun(QueryRunner<T> baseRunner, QueryPlus<T> queryPlus, ResponseContext context) {
        Query<T> query = queryPlus.getQuery();
        return CombiningSequence.create(baseRunner.run(queryPlus, context), this.comparatorGenerator.apply(query), this.mergeFnGenerator.apply(query));
    }
}

