/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.base.Preconditions;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.NullableAggregateCombiner;
import org.apache.druid.query.aggregation.NullableAggregator;
import org.apache.druid.query.aggregation.NullableBufferAggregator;
import org.apache.druid.query.aggregation.NullableVectorAggregator;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.segment.BaseNullableColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorValueSelector;

public abstract class NullableAggregatorFactory<T extends BaseNullableColumnValueSelector>
extends AggregatorFactory {
    @Override
    public final Aggregator factorize(ColumnSelectorFactory columnSelectorFactory) {
        T selector = this.selector(columnSelectorFactory);
        Aggregator aggregator = this.factorize(columnSelectorFactory, selector);
        return NullHandling.replaceWithDefault() ? aggregator : new NullableAggregator(aggregator, (BaseNullableColumnValueSelector)selector);
    }

    @Override
    public final BufferAggregator factorizeBuffered(ColumnSelectorFactory columnSelectorFactory) {
        T selector = this.selector(columnSelectorFactory);
        BufferAggregator aggregator = this.factorizeBuffered(columnSelectorFactory, selector);
        return NullHandling.replaceWithDefault() ? aggregator : new NullableBufferAggregator(aggregator, (BaseNullableColumnValueSelector)selector);
    }

    @Override
    public final VectorAggregator factorizeVector(VectorColumnSelectorFactory columnSelectorFactory) {
        Preconditions.checkState((boolean)this.canVectorize(), (Object)"Cannot vectorize");
        VectorValueSelector selector = this.vectorSelector(columnSelectorFactory);
        VectorAggregator aggregator = this.factorizeVector(columnSelectorFactory, selector);
        return NullHandling.replaceWithDefault() ? aggregator : new NullableVectorAggregator(aggregator, selector);
    }

    @Override
    public final AggregateCombiner makeNullableAggregateCombiner() {
        AggregateCombiner combiner = this.makeAggregateCombiner();
        return NullHandling.replaceWithDefault() ? combiner : new NullableAggregateCombiner(combiner);
    }

    @Override
    public final int getMaxIntermediateSizeWithNulls() {
        return this.getMaxIntermediateSize() + (NullHandling.replaceWithDefault() ? 0 : 1);
    }

    protected abstract T selector(ColumnSelectorFactory var1);

    protected VectorValueSelector vectorSelector(VectorColumnSelectorFactory columnSelectorFactory) {
        throw new UnsupportedOperationException("Cannot vectorize");
    }

    protected abstract Aggregator factorize(ColumnSelectorFactory var1, T var2);

    protected abstract BufferAggregator factorizeBuffered(ColumnSelectorFactory var1, T var2);

    protected VectorAggregator factorizeVector(VectorColumnSelectorFactory columnSelectorFactory, VectorValueSelector selector) {
        if (!this.canVectorize()) {
            throw new UnsupportedOperationException("Cannot vectorize");
        }
        throw new UnsupportedOperationException("canVectorize returned true but 'factorizeVector' is not implemented");
    }
}

