/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.segment.vector.VectorValueSelector;

public class NullableVectorAggregator
implements VectorAggregator {
    private final VectorAggregator delegate;
    private final VectorValueSelector selector;
    @Nullable
    private int[] vAggregationPositions = null;
    @Nullable
    private int[] vAggregationRows = null;

    NullableVectorAggregator(VectorAggregator delegate, VectorValueSelector selector) {
        this.delegate = delegate;
        this.selector = selector;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.put(position, (byte)1);
        this.delegate.init(buf, position + 1);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        boolean[] nullVector = this.selector.getNullVector();
        if (nullVector != null) {
            if (this.vAggregationPositions == null) {
                this.vAggregationPositions = new int[this.selector.getMaxVectorSize()];
                this.vAggregationRows = new int[this.selector.getMaxVectorSize()];
            }
            int j = 0;
            for (int i = startRow; i < endRow; ++i) {
                if (nullVector[i]) continue;
                this.vAggregationRows[j++] = i;
            }
            Arrays.fill(this.vAggregationPositions, 0, j, position);
            this.doAggregate(buf, j, this.vAggregationPositions, this.vAggregationRows, 0);
        } else {
            this.doAggregate(buf, position, startRow, endRow);
        }
    }

    @Override
    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        boolean[] nullVector = this.selector.getNullVector();
        if (nullVector != null) {
            if (this.vAggregationPositions == null) {
                this.vAggregationPositions = new int[this.selector.getMaxVectorSize()];
                this.vAggregationRows = new int[this.selector.getMaxVectorSize()];
            }
            int j = 0;
            for (int i = 0; i < numRows; ++i) {
                int rowNum;
                int n = rowNum = rows == null ? i : rows[i];
                if (nullVector[rowNum]) continue;
                this.vAggregationPositions[j] = positions[i];
                this.vAggregationRows[j] = rowNum;
                ++j;
            }
            this.doAggregate(buf, j, this.vAggregationPositions, this.vAggregationRows, positionOffset);
        } else {
            this.doAggregate(buf, numRows, positions, rows, positionOffset);
        }
    }

    @Override
    @Nullable
    public Object get(ByteBuffer buf, int position) {
        switch (buf.get(position)) {
            case 1: {
                return null;
            }
            case 0: {
                return this.delegate.get(buf, position + 1);
            }
        }
        throw new ISE("Bad null-marker byte, delegate class[%s]", new Object[]{this.delegate.getClass().getName()});
    }

    @Override
    public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuffer, ByteBuffer newBuffer) {
        this.delegate.relocate(oldPosition + 1, newPosition + 1, oldBuffer, newBuffer);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    private void doAggregate(ByteBuffer buf, int position, int start, int end) {
        buf.put(position, (byte)0);
        this.delegate.aggregate(buf, position + 1, start, end);
    }

    private void doAggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        for (int i = 0; i < numRows; ++i) {
            buf.put(positions[i] + positionOffset, (byte)0);
        }
        this.delegate.aggregate(buf, numRows, positions, rows, positionOffset + 1);
    }
}

