/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.first;

import java.nio.ByteBuffer;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;

public class StringFirstBufferAggregator
implements BufferAggregator {
    private final BaseLongColumnValueSelector timeSelector;
    private final BaseObjectColumnValueSelector valueSelector;
    private final int maxStringBytes;

    public StringFirstBufferAggregator(BaseLongColumnValueSelector timeSelector, BaseObjectColumnValueSelector valueSelector, int maxStringBytes) {
        this.timeSelector = timeSelector;
        this.valueSelector = valueSelector;
        this.maxStringBytes = maxStringBytes;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putLong(position, Long.MAX_VALUE);
        buf.putInt(position + 8, 0);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        long lastTime;
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        Object value = this.valueSelector.getObject();
        long time = this.timeSelector.getLong();
        String firstString = null;
        if (value != null) {
            if (value instanceof SerializablePairLongString) {
                SerializablePairLongString serializablePair = (SerializablePairLongString)((Object)value);
                time = (Long)serializablePair.lhs;
                firstString = (String)serializablePair.rhs;
            } else if (value instanceof String) {
                firstString = (String)value;
            } else {
                throw new ISE("Try to aggregate unsuported class type [%s].Supported class types: String or SerializablePairLongString", new Object[]{value.getClass().getName()});
            }
        }
        if (time < (lastTime = mutationBuffer.getLong(position))) {
            if (firstString != null) {
                if (firstString.length() > this.maxStringBytes) {
                    firstString = firstString.substring(0, this.maxStringBytes);
                }
                byte[] valueBytes = StringUtils.toUtf8((String)firstString);
                mutationBuffer.putLong(position, time);
                mutationBuffer.putInt(position + 8, valueBytes.length);
                mutationBuffer.position(position + 8 + 4);
                mutationBuffer.put(valueBytes);
            } else {
                mutationBuffer.putLong(position, time);
                mutationBuffer.putInt(position + 8, 0);
            }
        }
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        SerializablePairLongString serializablePair;
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        Long timeValue = mutationBuffer.getLong(position);
        int stringSizeBytes = mutationBuffer.getInt(position + 8);
        if (stringSizeBytes > 0) {
            byte[] valueBytes = new byte[stringSizeBytes];
            mutationBuffer.position(position + 8 + 4);
            mutationBuffer.get(valueBytes, 0, stringSizeBytes);
            serializablePair = new SerializablePairLongString(timeValue, StringUtils.fromUtf8((byte[])valueBytes));
        } else {
            serializablePair = new SerializablePairLongString(timeValue, null);
        }
        return serializablePair;
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("StringFirstAggregator does not support getFloat()");
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("StringFirstAggregator does not support getLong()");
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("StringFirstAggregator does not support getDouble()");
    }

    @Override
    public void close() {
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("timeSelector", this.timeSelector);
        inspector.visit("valueSelector", this.valueSelector);
    }
}

