/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.last;

import org.apache.druid.collections.SerializablePair;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;

public class DoubleLastAggregator
implements Aggregator {
    private final BaseDoubleColumnValueSelector valueSelector;
    private final BaseLongColumnValueSelector timeSelector;
    protected long lastTime;
    protected double lastValue;

    public DoubleLastAggregator(BaseLongColumnValueSelector timeSelector, BaseDoubleColumnValueSelector valueSelector) {
        this.valueSelector = valueSelector;
        this.timeSelector = timeSelector;
        this.lastTime = Long.MIN_VALUE;
        this.lastValue = 0.0;
    }

    @Override
    public void aggregate() {
        long time = this.timeSelector.getLong();
        if (time >= this.lastTime) {
            this.lastTime = time;
            this.lastValue = this.valueSelector.getDouble();
        }
    }

    @Override
    public Object get() {
        return new SerializablePair((Object)this.lastTime, (Object)this.lastValue);
    }

    @Override
    public float getFloat() {
        return (float)this.lastValue;
    }

    @Override
    public long getLong() {
        return (long)this.lastValue;
    }

    @Override
    public double getDouble() {
        return this.lastValue;
    }

    @Override
    public void close() {
    }
}

