/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.last;

import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;

public class StringLastAggregator
implements Aggregator {
    private final BaseObjectColumnValueSelector valueSelector;
    private final BaseLongColumnValueSelector timeSelector;
    private final int maxStringBytes;
    protected long lastTime;
    protected String lastValue;

    public StringLastAggregator(BaseLongColumnValueSelector timeSelector, BaseObjectColumnValueSelector valueSelector, int maxStringBytes) {
        this.valueSelector = valueSelector;
        this.timeSelector = timeSelector;
        this.maxStringBytes = maxStringBytes;
        this.lastTime = Long.MIN_VALUE;
        this.lastValue = null;
    }

    @Override
    public void aggregate() {
        long time = this.timeSelector.getLong();
        if (time >= this.lastTime) {
            this.lastTime = time;
            Object value = this.valueSelector.getObject();
            if (value != null) {
                if (value instanceof String) {
                    this.lastValue = (String)value;
                } else if (value instanceof SerializablePairLongString) {
                    this.lastValue = (String)((SerializablePairLongString)((Object)value)).rhs;
                } else {
                    throw new ISE("Try to aggregate unsuported class type [%s].Supported class types: String or SerializablePairLongString", new Object[]{value.getClass().getName()});
                }
                if (this.lastValue != null && this.lastValue.length() > this.maxStringBytes) {
                    this.lastValue = this.lastValue.substring(0, this.maxStringBytes);
                }
            } else {
                this.lastValue = null;
            }
        }
    }

    @Override
    public Object get() {
        return new SerializablePairLongString(this.lastTime, this.lastValue);
    }

    @Override
    public float getFloat() {
        throw new UnsupportedOperationException("StringFirstAggregator does not support getFloat()");
    }

    @Override
    public long getLong() {
        throw new UnsupportedOperationException("StringFirstAggregator does not support getLong()");
    }

    @Override
    public double getDouble() {
        throw new UnsupportedOperationException("StringFirstAggregator does not support getDouble()");
    }

    @Override
    public void close() {
    }
}

