/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.last;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.NullableAggregatorFactory;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.first.StringFirstAggregatorFactory;
import org.apache.druid.query.aggregation.last.StringLastAggregateCombiner;
import org.apache.druid.query.aggregation.last.StringLastAggregator;
import org.apache.druid.query.aggregation.last.StringLastBufferAggregator;
import org.apache.druid.query.aggregation.last.StringLastFoldingAggregatorFactory;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;

@JsonTypeName(value="stringLast")
public class StringLastAggregatorFactory
extends NullableAggregatorFactory<BaseObjectColumnValueSelector> {
    private final String fieldName;
    private final String name;
    protected final int maxStringBytes;

    @JsonCreator
    public StringLastAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="maxStringBytes") Integer maxStringBytes) {
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        Preconditions.checkNotNull((Object)fieldName, (Object)"Must have a valid, non-null fieldName");
        this.name = name;
        this.fieldName = fieldName;
        this.maxStringBytes = maxStringBytes == null ? 1024 : maxStringBytes;
    }

    @Override
    protected BaseObjectColumnValueSelector selector(ColumnSelectorFactory metricFactory) {
        return metricFactory.makeColumnValueSelector(this.fieldName);
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory, BaseObjectColumnValueSelector selector) {
        return new StringLastAggregator(metricFactory.makeColumnValueSelector("__time"), selector, this.maxStringBytes);
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory, BaseObjectColumnValueSelector selector) {
        return new StringLastBufferAggregator(metricFactory.makeColumnValueSelector("__time"), selector, this.maxStringBytes);
    }

    @Override
    public Comparator getComparator() {
        return StringFirstAggregatorFactory.VALUE_COMPARATOR;
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        return StringFirstAggregatorFactory.TIME_COMPARATOR.compare(lhs, rhs) > 0 ? lhs : rhs;
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        return new StringLastAggregateCombiner();
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new StringLastFoldingAggregatorFactory(this.name, this.name, this.maxStringBytes);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new StringLastAggregatorFactory(this.fieldName, this.fieldName, this.maxStringBytes));
    }

    @Override
    public Object deserialize(Object object) {
        Map map = (Map)object;
        return new SerializablePairLongString(((Number)map.get("lhs")).longValue(), (String)map.get("rhs"));
    }

    @Override
    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        return object == null ? null : ((SerializablePairLongString)((Object)object)).rhs;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public Integer getMaxStringBytes() {
        return this.maxStringBytes;
    }

    @Override
    public List<String> requiredFields() {
        return Arrays.asList("__time", this.fieldName);
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(44).appendString(this.fieldName).appendInt(this.maxStringBytes).build();
    }

    @Override
    public String getTypeName() {
        return "serializablePairLongString";
    }

    @Override
    public int getMaxIntermediateSize() {
        return 12 + this.maxStringBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringLastAggregatorFactory that = (StringLastAggregatorFactory)o;
        return this.fieldName.equals(that.fieldName) && this.name.equals(that.name) && this.maxStringBytes == that.maxStringBytes;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fieldName, this.maxStringBytes);
    }

    public String toString() {
        return "StringFirstAggregatorFactory{name='" + this.name + '\'' + ", fieldName='" + this.fieldName + '\'' + ", maxStringBytes=" + this.maxStringBytes + '\'' + '}';
    }
}

