/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.extraction;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.extraction.DimExtractionFn;
import org.apache.druid.query.extraction.ExtractionFn;

public abstract class FunctionalExtraction
extends DimExtractionFn {
    private final boolean retainMissingValue;
    private final String replaceMissingValueWith;
    private final Function<String, String> extractionFunction;
    private final ExtractionFn.ExtractionType extractionType;

    public FunctionalExtraction(final Function<String, String> extractionFunction, boolean retainMissingValue, String replaceMissingValueWith, boolean injective) {
        this.retainMissingValue = retainMissingValue;
        this.replaceMissingValueWith = NullHandling.emptyToNullIfNeeded((String)replaceMissingValueWith);
        Preconditions.checkArgument((!this.retainMissingValue || this.replaceMissingValueWith == null ? 1 : 0) != 0, (Object)"Cannot specify a [replaceMissingValueWith] and set [retainMissingValue] to true");
        this.extractionFunction = this.retainMissingValue ? new Function<String, String>(){

            @Nullable
            public String apply(@Nullable String dimValue) {
                String retval = (String)extractionFunction.apply((Object)dimValue);
                return NullHandling.isNullOrEquivalent((String)retval) ? NullHandling.emptyToNullIfNeeded((String)dimValue) : retval;
            }
        } : new Function<String, String>(){

            @Nullable
            public String apply(@Nullable String dimValue) {
                String retval = NullHandling.emptyToNullIfNeeded((String)((String)extractionFunction.apply((Object)dimValue)));
                return retval == null ? FunctionalExtraction.this.replaceMissingValueWith : retval;
            }
        };
        this.extractionType = injective ? ExtractionFn.ExtractionType.ONE_TO_ONE : ExtractionFn.ExtractionType.MANY_TO_ONE;
    }

    public boolean isRetainMissingValue() {
        return this.retainMissingValue;
    }

    public String getReplaceMissingValueWith() {
        return this.replaceMissingValueWith;
    }

    public boolean isInjective() {
        return ExtractionFn.ExtractionType.ONE_TO_ONE.equals((Object)this.getExtractionType());
    }

    @Override
    @Nullable
    public String apply(@Nullable String value) {
        return (String)this.extractionFunction.apply((Object)value);
    }

    @Override
    public boolean preservesOrdering() {
        return false;
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return this.extractionType;
    }
}

