/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter.vector;

import javax.annotation.Nullable;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.vector.BaseVectorValueMatcher;
import org.apache.druid.query.filter.vector.BooleanVectorValueMatcher;
import org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.druid.query.filter.vector.VectorMatch;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherFactory;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.vector.VectorValueSelector;

public class FloatVectorValueMatcher
implements VectorValueMatcherFactory {
    private final VectorValueSelector selector;

    public FloatVectorValueMatcher(VectorValueSelector selector) {
        this.selector = selector;
    }

    @Override
    public VectorValueMatcher makeMatcher(@Nullable String value) {
        Float matchVal = DimensionHandlerUtils.convertObjectToFloat(value);
        if (matchVal == null) {
            return BooleanVectorValueMatcher.of(this.selector, false);
        }
        final float matchValFloat = matchVal.floatValue();
        return new BaseVectorValueMatcher(this.selector){
            final VectorMatch match;
            {
                super(selector);
                this.match = VectorMatch.wrap(new int[FloatVectorValueMatcher.this.selector.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask) {
                float[] vector = FloatVectorValueMatcher.this.selector.getFloatVector();
                int[] selection = this.match.getSelection();
                int numRows = 0;
                for (int i = 0; i < mask.getSelectionSize(); ++i) {
                    int rowNum = mask.getSelection()[i];
                    if (vector[rowNum] != matchValFloat) continue;
                    selection[numRows++] = rowNum;
                }
                this.match.setSelectionSize(numRows);
                assert (this.match.isValid(mask));
                return this.match;
            }
        };
    }

    @Override
    public VectorValueMatcher makeMatcher(DruidPredicateFactory predicateFactory) {
        final DruidFloatPredicate predicate = predicateFactory.makeFloatPredicate();
        return new BaseVectorValueMatcher(this.selector){
            final VectorMatch match;
            {
                super(selector);
                this.match = VectorMatch.wrap(new int[FloatVectorValueMatcher.this.selector.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask) {
                float[] vector = FloatVectorValueMatcher.this.selector.getFloatVector();
                int[] selection = this.match.getSelection();
                int numRows = 0;
                for (int i = 0; i < mask.getSelectionSize(); ++i) {
                    int rowNum = mask.getSelection()[i];
                    if (!predicate.applyFloat(vector[rowNum])) continue;
                    selection[numRows++] = rowNum;
                }
                this.match.setSelectionSize(numRows);
                assert (this.match.isValid(mask));
                return this.match;
            }
        };
    }
}

