/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.column;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorPlus;
import org.apache.druid.query.groupby.epinephelinae.column.StringGroupByColumnSelectorStrategy;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.data.ArrayBasedIndexedInts;
import org.apache.druid.segment.data.IndexedInts;

public class DictionaryBuildingStringGroupByColumnSelectorStrategy
extends StringGroupByColumnSelectorStrategy {
    private static final int GROUP_BY_MISSING_VALUE = -1;
    private int nextId = 0;
    private final List<String> dictionary = new ArrayList<String>();
    private final Object2IntOpenHashMap<String> reverseDictionary = new Object2IntOpenHashMap();

    public DictionaryBuildingStringGroupByColumnSelectorStrategy() {
        this.reverseDictionary.defaultReturnValue(-1);
    }

    @Override
    public void processValueFromGroupingKey(GroupByColumnSelectorPlus selectorPlus, ByteBuffer key, ResultRow resultRow, int keyBufferPosition) {
        int id = key.getInt(keyBufferPosition);
        if (id != -1) {
            String value = this.dictionary.get(id);
            resultRow.set(selectorPlus.getResultRowPosition(), value);
        } else {
            resultRow.set(selectorPlus.getResultRowPosition(), NullHandling.defaultStringValue());
        }
    }

    @Override
    public void initColumnValues(ColumnValueSelector selector, int columnIndex, Object[] valuess) {
        DimensionSelector dimSelector = (DimensionSelector)selector;
        IndexedInts row = dimSelector.getRow();
        ArrayBasedIndexedInts newRow = (ArrayBasedIndexedInts)valuess[columnIndex];
        if (newRow == null) {
            newRow = new ArrayBasedIndexedInts();
            valuess[columnIndex] = newRow;
        }
        int rowSize = row.size();
        newRow.ensureSize(rowSize);
        for (int i = 0; i < rowSize; ++i) {
            String value = dimSelector.lookupName(row.get(i));
            int dictId = this.reverseDictionary.getInt((Object)value);
            if (dictId < 0) {
                this.dictionary.add(value);
                this.reverseDictionary.put((Object)value, this.nextId);
                newRow.setValue(i, this.nextId);
                ++this.nextId;
                continue;
            }
            newRow.setValue(i, dictId);
        }
        newRow.setSize(rowSize);
    }

    @Override
    public Object getOnlyValue(ColumnValueSelector selector) {
        DimensionSelector dimSelector = (DimensionSelector)selector;
        IndexedInts row = dimSelector.getRow();
        Preconditions.checkState((row.size() < 2 ? 1 : 0) != 0, (Object)"Not supported for multi-value dimensions");
        if (row.size() == 0) {
            return -1;
        }
        String value = dimSelector.lookupName(row.get(0));
        int dictId = this.reverseDictionary.getInt((Object)value);
        if (dictId < 0) {
            this.dictionary.add(value);
            this.reverseDictionary.put((Object)value, this.nextId);
            return this.nextId++;
        }
        return dictId;
    }
}

