/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.column;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorPlus;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorStrategy;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandlerUtils;

public class DoubleGroupByColumnSelectorStrategy
implements GroupByColumnSelectorStrategy {
    @Override
    public int getGroupingKeySize() {
        return 8;
    }

    @Override
    public void processValueFromGroupingKey(GroupByColumnSelectorPlus selectorPlus, ByteBuffer key, ResultRow resultRow, int keyBufferPosition) {
        double val = key.getDouble(keyBufferPosition);
        resultRow.set(selectorPlus.getResultRowPosition(), val);
    }

    @Override
    public void initColumnValues(ColumnValueSelector selector, int columnIndex, Object[] values) {
        values[columnIndex] = selector.getDouble();
    }

    @Override
    public Object getOnlyValue(ColumnValueSelector selector) {
        return selector.getDouble();
    }

    @Override
    public void writeToKeyBuffer(int keyBufferPosition, @Nullable Object obj, ByteBuffer keyBuffer) {
        keyBuffer.putDouble(keyBufferPosition, DimensionHandlerUtils.nullToZero((Double)obj));
    }

    @Override
    public void initGroupingKeyColumnValue(int keyBufferPosition, int columnIndex, Object rowObj, ByteBuffer keyBuffer, int[] stack) {
        this.writeToKeyBuffer(keyBufferPosition, rowObj, keyBuffer);
        stack[columnIndex] = 1;
    }

    @Override
    public boolean checkRowIndexAndAddValueToGroupingKey(int keyBufferPosition, Object rowObj, int rowValIdx, ByteBuffer keyBuffer) {
        return false;
    }
}

